% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.lmls}
\alias{summary.lmls}
\title{Summary for LMLS}
\usage{
\method{summary}{lmls}(
  object,
  type = c("ml", "boot", "mcmc"),
  digits = max(3, getOption("digits") - 3),
  ...
)
}
\arguments{
\item{object}{A location-scale regression model from the \code{\link[=lmls]{lmls()}} function.}

\item{type}{Either \code{"ml"} or \code{"boot"} or \code{"mcmc"}:
\itemize{
\item If \code{"ml"}, the maximum likelihood estimates and the
asymptotic standard errors are shown.
\item If \code{"boot"}, the bootstrap estimates and confidence
intervals are shown.
\item If \code{"mcmc"}, the Markov chain Monte Carlo (MCMC)
estimates and credible intervals are shown.
}}

\item{digits}{The number of digits to print.}

\item{...}{Passed on to \code{\link[=printCoefmat]{printCoefmat()}}.}
}
\value{
The (unmodified and invisible) \code{lmls} S3 object, see \code{\link[=lmls]{lmls()}}.
}
\description{
Prints a summary for location-scale regression models from the \code{\link[=lmls]{lmls()}}
function.
}
