% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mrrr.R
\name{predict.mrrr}
\alias{predict.mrrr}
\title{The function predict.mrrr makes predictions for a test/validation set
 based on a fitted mrrr model}
\usage{
\method{predict}{mrrr}(object, newX, ...)
}
\arguments{
\item{object}{An \code{mrrr} object}

\item{newX}{An N by P matrix with predictor variables for a test/validation set}

\item{\dots}{additional arguments to be passed.}
}
\value{
This function returns an object of the class \code{p.mru} with components:
\item{Ghat}{Predicted values for the test set}
}
\description{
The function predict.mrrr makes predictions for a test/validation set
 based on a fitted mrrr model
}
\examples{
\dontrun{
data(dataExample_lpca)
Y = as.matrix(dataExample_mru[-c(1:20) , 1:8])
X = as.matrix(dataExample_mru[-c(1:20) , 9:13])
newY = as.matrix(dataExample_mru[1:20 , 1:8])
newX = as.matrix(dataExample_mru[1:20 , 9:13])
output = mrrr(Y = Y, X = X, S = 2)
preds = predict(output, newX = newX)
}


}
