% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oos.comparison.R
\name{oos.comparison}
\alias{oos.comparison}
\title{This function compares the predictive performance of several models fitted on the same data}
\usage{
oos.comparison(objectlist, xlabel = "Model")
}
\arguments{
\item{objectlist}{An list with output objects from the bootstrap functions in lmap}

\item{xlabel}{A character object, specifying the label on the horizontal axis. Default is "Model"}
}
\value{
plot A boxplot with prediction errors for each model

pe A data frame with average prediction error for each bootstrap

fit A matrix with prediction error statistics for each model
}
\description{
The number of bootstraps should be the same for each model
Ideally, the seed used in bootstrapping should also be the same
}
\examples{
\dontrun{
data(dataExample_mru)
y = as.matrix(dataExample_mru[ , 1])
X = as.matrix(dataExample_mru[ , 2:6])
output2 = mrrr(y = y, X = X, S = 2)
b2 = bootstrap.mrrr(output2)
output3 = mrrr(y = y, X = X, S = 3)
b3 = bootstrap.mrrr(output3)
myobjects = list(b2, b3)
comparison = oos.comparison(myobjects)
comparison$plot
comparison$fit
}
}
