% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linpk.R
\name{pkprofile}
\alias{pkprofile}
\alias{pkprofile.default}
\alias{pkprofile.matrix}
\title{Generate a concentration-time profile.}
\usage{
pkprofile(...)

\method{pkprofile}{default}(
  t.obs = seq(0, 24, 0.1),
  cl = 1,
  vc = 5,
  q = numeric(0),
  vp = numeric(0),
  ka = 0,
  dose = list(t.dose = 0, amt = 1, rate = 0, dur = 0, ii = 24, addl = 0, ss = 0, cmt = 0,
    lag = 0, f = 1),
  sc = vc,
  initstate = NULL,
  ...
)

\method{pkprofile}{matrix}(
  A,
  t.obs = seq(0, 24, 0.1),
  dose = list(t.dose = 0, amt = 1, rate = 0, dur = 0, ii = 24, addl = 0, ss = 0, cmt = 0,
    lag = 0, f = 1),
  defdose = 1,
  sc = 1,
  initstate = NULL,
  ...
)
}
\arguments{
\item{...}{Further arguments passed along to other methods.}

\item{t.obs}{A numeric vector of times at which to observe concentrations.}

\item{cl}{Central clearance parameter.}

\item{vc}{Central volume parameter.}

\item{q}{Inter-compartmental clearance. Can be a vector for more than one
peripheral compartment, or empty for none. Must match \code{vp} in length.}

\item{vp}{Peripheral volume. Can be a vector for more than one
peripheral compartment, or empty for none. Must match \code{q} in length.}

\item{ka}{First-order absorption rate parameter. Set to 0 to indicate
that there is no first-order absorption (i.e. bolus or infusion).}

\item{dose}{A \code{list} or \code{data.frame} containing dose information.
May contain the following elements:
\describe{
  \item{\code{t.dose}}{Dose time (default 0).}
  \item{\code{amt}}{Dose amount (default 1).}
  \item{\code{rate}}{Rate of zero-order infusion, or 0 to ignore (default 0).
  Only one of \code{rate} and \code{dur} should be specified unless \code{amt} is missing.}
  \item{\code{dur}}{Duration of zero-order infusion, or 0 to ignore (default 0).
  Only one of \code{rate} and \code{dur} should be specified unless \code{amt} is missing.}
  \item{\code{ii}}{Interdose interval (default 24). Only used if addl or ss are used.}
  \item{\code{addl}}{Number of \emph{additional} doses (default 0). The
  total number of doses given is \code{addl + 1}.}
  \item{\code{ss}}{Indicates that a dose is given under steady-state
  conditions (default 0 or FALSE; converted to \code{logical} internally).}
  \item{\code{cmt}}{The number of the compartment into which the dose is
  administered. The default value is 0, which indicates the depot
  compartment for first-order absorption (i.e. \code{ka > 0}), and central
  compartment otherwise.}
  \item{\code{lag}}{Time lag (default 0).}
  \item{\code{f}}{Bioavailable fraction (default 1).}
}}

\item{sc}{A scaling constant for the central compartment. Concentrations are
obtained by dividing amounts by this constant.}

\item{initstate}{A numeric vector containing values to initialize the
compartments.}

\item{A}{A matrix of first-order rate constants between the compartments.}

\item{defdose}{The default dose compartment when the compartment is
missing or 0.}
}
\value{
An object of class "pkprofile", which is simply a numeric vector of
concentration values with some attributes attached to it.
This object has its own methods for \code{print}, \code{plot}, \code{lines} and \code{points}.
}
\description{
This function generates concentration-time profiles from a linear
pharmacokinetic (PK) system, possibly with first-order absorption or
zero-order infusion, possibly with one or more peripheral compartments, and
possibly under steady-state conditions. Single or multiple doses may be
specified.
}
\section{Methods (by class)}{
\itemize{
\item \code{pkprofile(default)}: Default method.

\item \code{pkprofile(matrix)}: Matrix method.

}}
\section{Warning}{

Pay attention to the default arguments. They are there for convenience, but
may lead to undesired results if one is not careful.
}

\examples{
# Default values, a bolus injection
y <- pkprofile()
plot(y)

t.obs <- seq(0, 24, 0.1)
dur <- 1
amt <- 1
ka <- 1
cl <- 0.25
vc <- 5
q <- 2.5
vp <- 10

# One-compartment model with first-order absorption, single dose
y <- pkprofile(t.obs, cl=cl, vc=vc, ka=ka, dose=list(amt=amt))
plot(y)

# Two-compartment model with first-order absorption, single dose
y <- pkprofile(t.obs, cl=cl, vc=vc, vp=vp, q=q, ka=ka, dose=list(amt=amt))
plot(y)

# One-compartment model with zero-order infusion, single dose
y <- pkprofile(t.obs, cl=cl, vc=vc, dose=list(dur=dur, amt=amt))
plot(y)

# Two-compartment model with zero-order infusion, single dose
y <- pkprofile(t.obs, cl=cl, vc=vc, vp=vp, q=q, dose=list(dur=dur, amt=amt))
plot(y)

# Two-compartment model with bolus injection, single dose
y <- pkprofile(t.obs, cl=cl, vc=vc, vp=vp, q=q, dose=list(amt=amt))
plot(y)

# Two-compartment model with bolus injection into the peripheral compartment, single dose
y <- pkprofile(t.obs, cl=cl, vc=vc, vp=vp, q=q, dose=list(amt=amt, cmt=2))
plot(y)

# Two-compartment model with zero-order infusion into the peripheral compartment, single dose
y <- pkprofile(t.obs, cl=cl, vc=vc, vp=vp, q=q, dose=list(amt=amt, cmt=2, dur=dur))
plot(y)

t.obs <- seq(0, 24*6, 1)

# One-compartment model with first-order absorption, multiple doses
y <- pkprofile(t.obs, cl=cl, vc=vc, ka=ka, dose=list(t.dose=seq(0, 24*5, 12), amt=amt))
plot(y)

# One-compartment model with first-order absorption, multiple doses specified by addl and ii
y <- pkprofile(t.obs, cl=cl, vc=vc, ka=ka, dose=list(t.dose=0, amt=amt, addl=9, ii=12))
plot(y, type="b")
points(y, col="blue")

# One-compartment model with first-order absorption, multiple doses under steady-state conditions
yss <- pkprofile(t.obs, cl=cl, vc=vc, ka=ka, dose=list(t.dose=0, amt=amt, addl=9, ii=12, ss=1))
lines(yss, col="red")
points(yss, col="green")

# One-compartment model with zero-order infusion, multiple doses specified by addl and ii
y <- pkprofile(t.obs, cl=cl, vc=vc, dose=list(dur=dur, amt=amt, addl=9, ii=12))
plot(y, log="y")

# One-compartment model with zero-order infusion, multiple doses  under steady-state conditions
yss <- pkprofile(t.obs, cl=cl, vc=vc, dose=list(dur=dur, amt=amt, addl=9, ii=12, ss=1))
lines(yss, col="red")

}
\seealso{
\itemize{
  \item \code{\link{halflife}}
  \item \code{\link{secondary}}
  \item \code{\link{print.pkprofile}}
  \item \code{\link{plot.pkprofile}}
  \item \code{\link{lines.pkprofile}}
  \item \code{\link{points.pkprofile}}
}
}
