% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{reset_test}
\alias{reset_test}
\title{Reset test.
Tests the specification of a linear model adding and testing
powers of fitted values.}
\usage{
reset_test(
  model,
  robust = FALSE,
  vcov = NULL,
  max_power = 3,
  quantiles = c(0.9, 0.95, 0.99)
)
}
\arguments{
\item{model}{An existing fit from a model function such as `lm`, `lfe` and others
compatible with `update`.}

\item{robust}{Use robust `varcov` matrix.}

\item{vcov}{Particular variance and covariances matrix.}

\item{max_power}{Max power of fitted values to add.}

\item{quantiles}{Vector of quantiles to calculate pvalues.}
}
\value{
A `tibble` with the Wald value, the corresponding pvalue, and the quantiles of the distribution.
}
\description{
Reset test.
Tests the specification of a linear model adding and testing
powers of fitted values.
}
\examples{
x <- 1:10  + rnorm(10)
y <- 1:10
model <- lm(y~x)
r_test <- reset_test(model)
r_test <- reset_test(model, robust = TRUE)
r_test <- reset_test(model, quantiles = c(.97))
r_test <- reset_test(model, max_power = 4)
r_test <- reset_test(model, robust = TRUE, max_power = 4)
}
