% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6_survey.R
\name{Survey}
\alias{Survey}
\title{R6 Class representing a LimeSurvey survey}
\description{
R6 Class representing a LimeSurvey survey

R6 Class representing a LimeSurvey survey
}
\details{
Create and work with a Survey to programmatically (or interactively)
create a survey, export it to a tab separated values file, and import
it to LimeSurvey.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{titles}}{The title of the survey in the primary language and
any additional languages}

\item{\code{descriptions}}{The descriptions of the survey in the primary
language and any additional languages}

\item{\code{welcomeTexts}}{The welcome texts of the survey in the primary
language and any additional languages}

\item{\code{endTexts}}{The end texts of the survey in the primary
language and any additional languages}

\item{\code{endURLs}}{The end URLs of the survey in the primary
language and any additional languages}

\item{\code{endURLdescriptions}}{The end URL descriptions of the survey in
the primary language and any additional languages}

\item{\code{dateformats}}{The date format to use in
the primary language and any additional languages; the index of
the option from the dropdown in LimeSurvey (6 is the ISO standard,
"YYYY-MM-DD").}

\item{\code{numberformats}}{The number format to use in
the primary language and any additional languages (for periods as
decimal marks, \code{0}; for commas as decimal marks, \code{1}).}

\item{\code{sid}}{The unique survey identifier; if this is free when
importing the survey, this will be used.}

\item{\code{gsid}}{The Survey Group identifier.}

\item{\code{admin}}{The name of the survey administrator}

\item{\code{adminemail}}{The email address of the survey administrator}

\item{\code{anonymized}}{Whether the survey uses anonymized
responses (\code{Y} or \code{N}).}

\item{\code{faxto}}{The contents of the "Fax to" field}

\item{\code{format}}{How to present the survey (\code{Q} for question by
question; \code{G} for group by group; and \code{A} for all in one).}

\item{\code{savetimings}}{Whether to save timings of responses (\code{Y} or \code{N}).}

\item{\code{template}}{The name of the LimeSurvey theme to use.}

\item{\code{language}}{The primary language of the survey.}

\item{\code{additional_languages}}{Any additional languages the survey uses.}

\item{\code{datestamp}}{Whether to datestamp responses (\code{Y} or \code{N}).}

\item{\code{usecookie}}{Whether to use cookies to enable answer persistence.}

\item{\code{allowregister}}{Whether to allow public registration (\code{Y} or \code{N}).}

\item{\code{allowsave}}{Whether to allow users to save their responses and
returning later (\code{Y} or \code{N}).}

\item{\code{autonumber_start}}{Where to start autonumbering}

\item{\code{autoredirect}}{Whether to automatically redirect users to a
URL (\code{Y} or \code{N}).}

\item{\code{allowprev}}{Whether to allow users to return to previous
pages (\code{Y} or \code{N}).}

\item{\code{printanswers}}{Whether to allow printing of answer (\code{Y} or \code{N}).}

\item{\code{ipaddr}}{Whether to store IP addresses (\code{Y} or \code{N}).}

\item{\code{refurl}}{Whether to store the referring URL (\code{Y} or \code{N}).}

\item{\code{showsurveypolicynotice}}{Whether to show the data policy
notice (\code{Y} or \code{N}).}

\item{\code{publicstatistics}}{Whether to have public statistics (\code{Y} or \code{N}).}

\item{\code{publicgraphs}}{Whether to show graphs in public
statistics (\code{Y} or \code{N}).}

\item{\code{listpublic}}{Whether to list the survey publicly (\code{Y} or \code{N}).}

\item{\code{htmlemail}}{Whether to use HTML format for token
emails (\code{Y} or \code{N}).}

\item{\code{sendconfirmation}}{Whether to send confirmation
emails (\code{Y} or \code{N}).}

\item{\code{tokenanswerspersistence}}{Whether to use token-based
response persistence (\code{Y} or \code{N}).}

\item{\code{assessments}}{Whether to use assessments (\code{Y} or \code{N}).}

\item{\code{usecaptcha}}{Whether to use CAPTCHA's (\code{Y} or \code{N}).}

\item{\code{usetokens}}{Whether to use tokens (\code{Y} or \code{N}).}

\item{\code{bounce_email}}{Where bouncing emails should be sent.}

\item{\code{emailresponseto}}{Where detailed admin notifications emails
should be sent.}

\item{\code{emailnotificationto}}{Where a notification should be sent for new
responses.}

\item{\code{tokenlength}}{The token length.}

\item{\code{showxquestions}}{Whether to show "There are X questions in this
survey" (\code{Y} or \code{N}).}

\item{\code{showgroupinfo}}{Whether to show group name and info (\code{B} for both,
\verb{?}, or \code{X} to show nothing).}

\item{\code{shownoanswer}}{Whether to show the "No answer" option (\code{Y} or \code{N}).}

\item{\code{showqnumcode}}{Whether to show answer codes or numbers  (\code{Y}, \code{N},
or \code{X} to show nothing).}

\item{\code{bounceprocessing}}{Whether to process bouncing emails? (\code{Y} or \code{N}).}

\item{\code{showwelcome}}{Whether to show the welcome page (\code{Y} or \code{N}).}

\item{\code{showprogress}}{Whether to show the progress bar (\code{Y} or \code{N}).}

\item{\code{questionindex}}{Whether to show the question index  (\code{0} to
disable; can also be set to incremental or full (\code{1} and \code{2}?)).}

\item{\code{navigationdelay}}{The navigation delay in seconds}

\item{\code{nokeyboard}}{Whether to show the on-screen keyboard (\code{Y} or \code{N}).}

\item{\code{alloweditaftercompletion}}{Whether to allow multiple
reponses (\code{N}) or to allow updating responses with one token (\code{Y})?}

\item{\code{googleanalyticsstyle}}{The google analytics settings; \code{0} for None,
other values for other settings.}

\item{\code{googleanalyticsapikey}}{The google analytics API key.}

\item{\code{groups}}{The groups in the survey.}

\item{\code{tsvData}}{Used to store the dataframe saved to a file as
tab separated values.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{get_group_ids}}{A list of all group ids.}

\item{\code{get_group_titles}}{A list of all group ids.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Survey-new}{\code{Survey$new()}}
\item \href{#method-Survey-add_group}{\code{Survey$add_group()}}
\item \href{#method-Survey-add_question}{\code{Survey$add_question()}}
\item \href{#method-Survey-export_to_tsv}{\code{Survey$export_to_tsv()}}
\item \href{#method-Survey-find_group_id}{\code{Survey$find_group_id()}}
\item \href{#method-Survey-clone}{\code{Survey$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Survey-new"></a>}}
\if{latex}{\out{\hypertarget{method-Survey-new}{}}}
\subsection{Method \code{new()}}{
Create a new survey object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Survey$new(
  titles,
  descriptions = "",
  welcomeTexts = "",
  endTexts = "",
  endURLs = "",
  endURLdescriptions = "",
  dateformats = 6,
  numberformats = 0,
  sid = 1,
  gsid = 1,
  admin = "Admin Name",
  adminemail = "email@add.ress",
  anonymized = "Y",
  faxto = "",
  format = "G",
  savetimings = "Y",
  template = "vanilla",
  language = "en",
  additional_languages = "",
  datestamp = "Y",
  usecookie = "N",
  allowregister = "N",
  allowsave = "N",
  autonumber_start = 0,
  autoredirect = "Y",
  allowprev = "N",
  printanswers = "N",
  ipaddr = "N",
  refurl = "N",
  showsurveypolicynotice = "0",
  publicstatistics = "N",
  publicgraphs = "N",
  listpublic = "N",
  htmlemail = "Y",
  sendconfirmation = "N",
  tokenanswerspersistence = "N",
  assessments = "N",
  usecaptcha = "N",
  usetokens = "N",
  bounce_email = "",
  emailresponseto = "",
  emailnotificationto = "",
  tokenlength = 15,
  showxquestions = "N",
  showgroupinfo = "X",
  shownoanswer = "N",
  showqnumcode = "X",
  bounceprocessing = "N",
  showwelcome = "N",
  showprogress = "N",
  questionindex = "0",
  navigationdelay = "0",
  nokeyboard = "N",
  alloweditaftercompletion = "N",
  googleanalyticsstyle = 0,
  googleanalyticsapikey = "",
  new_id_fun = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{titles}}{The titles of the survey in the primary language and
optionally any addiitonal languages.}

\item{\code{descriptions}}{The descriptions of the survey in the primary
language and any additional languages}

\item{\code{welcomeTexts}}{The welcome texts of the survey in the primary
language and any additional languages}

\item{\code{endTexts}}{The end texts of the survey in the primary
language and any additional languages}

\item{\code{endURLs}}{The end URLs of the survey in the primary
language and any additional languages}

\item{\code{endURLdescriptions}}{The end URL descriptions of the survey in
the primary language and any additional languages}

\item{\code{dateformats}}{The date formats to use in
the primary language and any additional languages; the index of
the option from the dropdown in LimeSurvey (6 is the ISO standard,
"YYYY-MM-DD").}

\item{\code{numberformats}}{The number formats to use in
the primary language and any additional languages (for periods as
decimal marks, \code{0}; for commas as decimal marks, \code{1}).}

\item{\code{sid}}{The unique survey identifier; if this is free when
importing the survey, this will be used.}

\item{\code{gsid}}{The Survey Group identifier.}

\item{\code{admin}}{The name of the survey administrator}

\item{\code{adminemail}}{The email address of the survey administrator}

\item{\code{anonymized}}{Whether the survey uses anonymized
responses (\code{Y} or \code{N}).}

\item{\code{faxto}}{The contents of the "Fax to" field}

\item{\code{format}}{How to present the survey (\code{Q} for question by
question; \code{G} for group by group; and \code{A} for all in one).}

\item{\code{savetimings}}{Whether to save timings of responses (\code{Y} or \code{N}).}

\item{\code{template}}{The name of the LimeSurvey theme to use.}

\item{\code{language}}{The primary language of the survey.}

\item{\code{additional_languages}}{Any additional languages the survey uses.}

\item{\code{datestamp}}{Whether to datestamp responses (\code{Y} or \code{N}).}

\item{\code{usecookie}}{Whether to use cookies to enable answer persistence.}

\item{\code{allowregister}}{Whether to allow public registration (\code{Y} or \code{N}).}

\item{\code{allowsave}}{Whether to allow users to save their responses and
returning later (\code{Y} or \code{N}).}

\item{\code{autonumber_start}}{Where to start autonumbering}

\item{\code{autoredirect}}{Whether to automatically redirect users to a
URL (\code{Y} or \code{N}).}

\item{\code{allowprev}}{Whether to allow users to return to previous
pages (\code{Y} or \code{N}).}

\item{\code{printanswers}}{Whether to allow printing of answer (\code{Y} or \code{N}).}

\item{\code{ipaddr}}{Whether to store IP addresses (\code{Y} or \code{N}).}

\item{\code{refurl}}{Whether to store the referring URL (\code{Y} or \code{N}).}

\item{\code{showsurveypolicynotice}}{Whether to show the data policy
notice (\code{Y} or \code{N}).}

\item{\code{publicstatistics}}{Whether to have public statistics (\code{Y} or \code{N}).}

\item{\code{publicgraphs}}{Whether to show graphs in public
statistics (\code{Y} or \code{N}).}

\item{\code{listpublic}}{Whether to list the survey publicly (\code{Y} or \code{N}).}

\item{\code{htmlemail}}{Whether to use HTML format for token
emails (\code{Y} or \code{N}).}

\item{\code{sendconfirmation}}{Whether to send confirmation
emails (\code{Y} or \code{N}).}

\item{\code{tokenanswerspersistence}}{Whether to use token-based
response persistence (\code{Y} or \code{N}).}

\item{\code{assessments}}{Whether to use assessments (\code{Y} or \code{N}).}

\item{\code{usecaptcha}}{Whether to use CAPTCHA's (\code{Y} or \code{N}).}

\item{\code{usetokens}}{Whether to use tokens (\code{Y} or \code{N}).}

\item{\code{bounce_email}}{Where bouncing emails should be sent.}

\item{\code{emailresponseto}}{Where detailed admin notifications emails
should be sent.}

\item{\code{emailnotificationto}}{Where a notification should be sent for new
responses.}

\item{\code{tokenlength}}{The token length.}

\item{\code{showxquestions}}{Whether to show "There are X questions in this
survey" (\code{Y} or \code{N}).}

\item{\code{showgroupinfo}}{Whether to show group name and info (\code{Y}, \code{N},
or \code{X} to show nothing).}

\item{\code{shownoanswer}}{Whether to show the "No answer" option (\code{Y} or \code{N}).}

\item{\code{showqnumcode}}{Whether to show answer codes or numbers  (\code{Y}, \code{N},
or \code{X} to show nothing).}

\item{\code{bounceprocessing}}{Whether to process bouncing emails? (\code{Y} or \code{N}).}

\item{\code{showwelcome}}{Whether to show the welcome page (\code{Y} or \code{N}).}

\item{\code{showprogress}}{Whether to show the progress bar (\code{Y} or \code{N}).}

\item{\code{questionindex}}{Whether to show the question index  (\code{0} to
disable; can also be set to incremental or full (\code{1} and \code{2}?)).}

\item{\code{navigationdelay}}{The navigation delay in seconds}

\item{\code{nokeyboard}}{Whether to show the on-screen keyboard (\code{Y} or \code{N}).}

\item{\code{alloweditaftercompletion}}{Whether to allow multiple
reponses (\code{N}) or to allow updating responses with one token (\code{Y})?}

\item{\code{googleanalyticsstyle}}{The google analytics settings; \code{0} for None,
other values for other settings.}

\item{\code{googleanalyticsapikey}}{The google analytics API key.}

\item{\code{new_id_fun}}{A function to set identifiers (for XML exports, which
mirrors MySQL tables and so needs identifiers). By default, new question
objects receive this function from the group containing them; and groups
receive it from the survey containing them. This ensures that identifiers
are always unique in a survey (despite question objects not being able
to 'see' anything in the group containing them, and group objects not
being able to 'see' anything in the survey containing them; because they
'received' this function from the parent object, and it 'bubbles down'
through groups to the questions, those functions still get and set a
private identifier property in the 'top-most' object).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Survey} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Survey-add_group"></a>}}
\if{latex}{\out{\hypertarget{method-Survey-add_group}{}}}
\subsection{Method \code{add_group()}}{
Add a group to a survey object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Survey$add_group(titles, descriptions = "", relevance = 1, random_group = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{titles}}{The group's title, either as a named character vector
where each element is the group title in a different language, and
every element's name is the language code; or as a single character
value, in which case the survey's primary language is used.}

\item{\code{descriptions}}{The group description, either as a named character
vector where each element is the group description in a different
language, and every element's name is the language code; or as a single
character value, in which case the survey's primary language is used.}

\item{\code{relevance}}{The group's relevance equation.}

\item{\code{random_group}}{The group's randomization group.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly, the \code{Survey} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Survey-add_question"></a>}}
\if{latex}{\out{\hypertarget{method-Survey-add_question}{}}}
\subsection{Method \code{add_question()}}{
Add a question to a survey object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Survey$add_question(groupId, code, type = NULL, lsType = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{groupId}}{The id of the group to add the question to.}

\item{\code{code}}{The question code.}

\item{\code{type}}{The question type.}

\item{\code{lsType}}{The question type, as LimeSurvey question type.}

\item{\code{...}}{Additional arguments are used to create the Question using
\code{Question$new}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly, the \code{Survey} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Survey-export_to_tsv"></a>}}
\if{latex}{\out{\hypertarget{method-Survey-export_to_tsv}{}}}
\subsection{Method \code{export_to_tsv()}}{
Export the survey as a tab separated values file (see
https://manual.limesurvey.org/Tab_Separated_Value_survey_structure).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Survey$export_to_tsv(
  file,
  preventOverwriting = limonaid::opts$get("preventOverwriting"),
  parallel = TRUE,
  encoding = limonaid::opts$get("encoding"),
  silent = limonaid::opts$get("silent"),
  backupLanguage = self$language
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{The filename to which to save the file.}

\item{\code{preventOverwriting}}{Whether to prevent overwriting.}

\item{\code{parallel}}{Whether to work serially or in parallel.}

\item{\code{encoding}}{The encoding to use}

\item{\code{silent}}{Whether to be silent or chatty.}

\item{\code{backupLanguage}}{The language to get content from if not from
the primary langage.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly, the \code{Survey} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Survey-find_group_id"></a>}}
\if{latex}{\out{\hypertarget{method-Survey-find_group_id}{}}}
\subsection{Method \code{find_group_id()}}{
Find the numeric group identifier by group title.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Survey$find_group_id(title, titleLanguage = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{The survey title.}

\item{\code{titleLanguage}}{The language in which to search.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly, the \code{Survey} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Survey-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Survey-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Survey$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
