% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multithreading.R
\name{getLGBMThreads}
\alias{getLGBMThreads}
\alias{getLGBMthreads}
\title{Get default number of threads used by LightGBM}
\usage{
getLGBMthreads()
}
\value{
number of threads as an integer. \code{-1} means that in situations where parameter \code{num_threads} is
        not explicitly supplied, LightGBM will choose a number of threads to use automatically.
}
\description{
LightGBM attempts to speed up many operations by using multi-threading.
             The number of threads used in those operations can be controlled via the
             \code{num_threads} parameter passed through \code{params} to functions like
             \link{lgb.train} and \link{lgb.Dataset}. However, some operations (like materializing
             a model from a text file) are done via code paths that don't explicitly accept thread-control
             configuration.

             Use this function to see the default number of threads LightGBM will use for such operations.
}
\seealso{
\link{setLGBMthreads}
}
