% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/less-classifier.R
\name{LESSClassifier}
\alias{LESSClassifier}
\title{LESSClassifier}
\value{
R6 class of LESSClassifier
}
\description{
Classifier for Learning with Subset Stacking (LESS)
}
\examples{

## ------------------------------------------------
## Method `LESSClassifier$new`
## ------------------------------------------------

lessclassifier <- LESSClassifier$new()
lessclassifier <- LESSClassifier$new(multiclass = "ovo")

## ------------------------------------------------
## Method `LESSClassifier$fit`
## ------------------------------------------------

data(iris)
set.seed(2022)
shuffled_iris <- iris[sample(1:nrow(iris)),]
split_list <- train_test_split(shuffled_iris[1:10,], test_size =  0.3, random_state = 1)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

lessclassifier <- LESSClassifier$new()
lessclassifier$fit(X_train, y_train)

## ------------------------------------------------
## Method `LESSClassifier$predict`
## ------------------------------------------------

preds <- lessclassifier$predict(X_test)
print(caret::confusionMatrix(data=factor(preds), reference = factor(y_test)))

## ------------------------------------------------
## Method `LESSClassifier$get_estimator_type`
## ------------------------------------------------

lessclassifier$get_estimator_type()

## ------------------------------------------------
## Method `LESSClassifier$set_random_state`
## ------------------------------------------------

lessclassifier$set_random_state(2022)
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{\link[less:LESSBase]{less::LESSBase}} -> \code{LESSClassifier}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LESSClassifier-new}{\code{LESSClassifier$new()}}
\item \href{#method-LESSClassifier-fit}{\code{LESSClassifier$fit()}}
\item \href{#method-LESSClassifier-predict}{\code{LESSClassifier$predict()}}
\item \href{#method-LESSClassifier-get_estimator_type}{\code{LESSClassifier$get_estimator_type()}}
\item \href{#method-LESSClassifier-set_random_state}{\code{LESSClassifier$set_random_state()}}
\item \href{#method-LESSClassifier-clone}{\code{LESSClassifier$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_d_normalize"><a href='../../less/html/LESSBase.html#method-LESSBase-get_d_normalize'><code>less::LESSBase$get_d_normalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_frac"><a href='../../less/html/LESSBase.html#method-LESSBase-get_frac'><code>less::LESSBase$get_frac()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_isFitted"><a href='../../less/html/LESSBase.html#method-LESSBase-get_isFitted'><code>less::LESSBase$get_isFitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_n_neighbors"><a href='../../less/html/LESSBase.html#method-LESSBase-get_n_neighbors'><code>less::LESSBase$get_n_neighbors()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_n_replications"><a href='../../less/html/LESSBase.html#method-LESSBase-get_n_replications'><code>less::LESSBase$get_n_replications()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_n_subsets"><a href='../../less/html/LESSBase.html#method-LESSBase-get_n_subsets'><code>less::LESSBase$get_n_subsets()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_random_state"><a href='../../less/html/LESSBase.html#method-LESSBase-get_random_state'><code>less::LESSBase$get_random_state()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_replications"><a href='../../less/html/LESSBase.html#method-LESSBase-get_replications'><code>less::LESSBase$get_replications()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_scaling"><a href='../../less/html/LESSBase.html#method-LESSBase-get_scaling'><code>less::LESSBase$get_scaling()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="LESSBase" data-id="get_val_size"><a href='../../less/html/LESSBase.html#method-LESSBase-get_val_size'><code>less::LESSBase$get_val_size()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSClassifier-new"></a>}}
\if{latex}{\out{\hypertarget{method-LESSClassifier-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of LESSClassifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSClassifier$new(
  frac = NULL,
  n_neighbors = NULL,
  n_subsets = NULL,
  n_replications = 20,
  d_normalize = TRUE,
  val_size = NULL,
  random_state = NULL,
  tree_method = function(X) KDTree$new(X),
  cluster_method = NULL,
  local_estimator = LinearRegression$new(),
  global_estimator = DecisionTreeClassifier$new(),
  distance_function = NULL,
  scaling = TRUE,
  warnings = TRUE,
  multiclass = "ovr"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{frac}}{fraction of total samples used for the number of neighbors (default is 0.05)}

\item{\code{n_neighbors}}{number of neighbors (default is NULL)}

\item{\code{n_subsets}}{number of subsets (default is NULL)}

\item{\code{n_replications}}{number of replications (default is 20)}

\item{\code{d_normalize}}{distance normalization (default is TRUE)}

\item{\code{val_size}}{percentage of samples used for validation (default is NULL - no validation)}

\item{\code{random_state}}{initialization of the random seed (default is NULL)}

\item{\code{tree_method}}{method used for constructing the nearest neighbor tree, e.g., less::KDTree (default)}

\item{\code{cluster_method}}{method used for clustering the subsets, e.g., less::KMeans (default is NULL)}

\item{\code{local_estimator}}{estimator for the local models (default is less::LinearRegression)}

\item{\code{global_estimator}}{estimator for the global model (default is less::DecisionTreeRegressor)}

\item{\code{distance_function}}{distance function evaluating the distance from a subset to a sample,
e.g., df(subset, sample) which returns a vector of distances (default is RBF(subset, sample, 1.0/n_subsets^2))}

\item{\code{scaling}}{flag to normalize the input data (default is TRUE)}

\item{\code{warnings}}{flag to turn on (TRUE) or off (FALSE) the warnings (default is TRUE)}

\item{\code{multiclass}}{available strategies are 'ovr' (one-vs-rest, default), 'ovo' (one-vs-one), 'occ' (output-code-classifier) (default is 'ovr')}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{lessclassifier <- LESSClassifier$new()
lessclassifier <- LESSClassifier$new(multiclass = "ovo")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSClassifier-fit"></a>}}
\if{latex}{\out{\hypertarget{method-LESSClassifier-fit}{}}}
\subsection{Method \code{fit()}}{
Dummy fit function that calls the fit method of the multiclass strategy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSClassifier$fit(X, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{2D matrix or dataframe that includes predictors}

\item{\code{y}}{1D vector or (n,1) dimensional matrix/dataframe that includes response variables}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Fitted R6 Class of LESSClassifier
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(iris)
set.seed(2022)
shuffled_iris <- iris[sample(1:nrow(iris)),]
split_list <- train_test_split(shuffled_iris[1:10,], test_size =  0.3, random_state = 1)
X_train <- split_list[[1]]
X_test <- split_list[[2]]
y_train <- split_list[[3]]
y_test <- split_list[[4]]

lessclassifier <- LESSClassifier$new()
lessclassifier$fit(X_train, y_train)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSClassifier-predict"></a>}}
\if{latex}{\out{\hypertarget{method-LESSClassifier-predict}{}}}
\subsection{Method \code{predict()}}{
Dummy predict function that calls the predict method of the multiclass strategy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSClassifier$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{2D matrix or dataframe that includes predictors}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Predicted values of the given predictors
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{preds <- lessclassifier$predict(X_test)
print(caret::confusionMatrix(data=factor(preds), reference = factor(y_test)))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSClassifier-get_estimator_type"></a>}}
\if{latex}{\out{\hypertarget{method-LESSClassifier-get_estimator_type}{}}}
\subsection{Method \code{get_estimator_type()}}{
Auxiliary function returning the estimator type e.g 'regressor', 'classifier'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSClassifier$get_estimator_type()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{lessclassifier$get_estimator_type()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSClassifier-set_random_state"></a>}}
\if{latex}{\out{\hypertarget{method-LESSClassifier-set_random_state}{}}}
\subsection{Method \code{set_random_state()}}{
Auxiliary function that sets random state attribute of the self class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSClassifier$set_random_state(random_state)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{random_state}}{seed number to be set as random state}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{lessclassifier$set_random_state(2022)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSClassifier-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LESSClassifier-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSClassifier$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
