% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitive-bracket.R
\name{primitive_bracket}
\alias{primitive_bracket}
\title{Guide primitive: brackets}
\usage{
primitive_bracket(
  key = "range_auto",
  bracket = "line",
  angle = waiver(),
  oob = "squish",
  drop_zero = TRUE,
  pad_discrete = 0.4,
  levels_brackets = NULL,
  levels_text = NULL,
  theme = NULL,
  position = waiver()
)
}
\arguments{
\item{key}{A \link[=key_range]{range key} specification. See more information
in the linked topic.}

\item{bracket}{A \link[=bracket_options]{bracket} by providing one of the
following:
\itemize{
\item A bracket \verb{<function>}, such as \code{bracket_square}.
\item A \verb{<character[1]>} naming a bracket function without the
'\code{bracket_}'-prefix, e.g. \code{"square"}.
\item A two-column \verb{<matrix[n, 2]>} giving line coordinates for a bracket,
like those created by bracket functions, such as \code{bracket_round()}.
}}

\item{angle}{A specification for the text angle. Compared to setting the \code{angle} argument
in \code{\link[ggplot2:element]{element_text()}}, this argument uses some
heuristics to automatically pick the \code{hjust} and \code{vjust} that you
probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take angles and justification settings directly from the theme.
\item \code{\link[ggplot2:waiver]{waiver()}} to allow reasonable defaults in special
cases.
\item A \verb{<numeric[1]>} between -360 and 360 for the text angle in degrees.
}}

\item{oob}{A method for dealing with out-of-bounds (oob) ranges. Can be one
of \code{"squish"}, \code{"censor"} or \code{"none"}.}

\item{drop_zero}{A \verb{<logical[1]>} whether to drop near-zero width ranges
(\code{TRUE}, default) or preserve them (\code{FALSE}).}

\item{pad_discrete}{A \verb{<numeric[1]>} giving the amount ranges should be
extended when given as a discrete variable. This is applied after
the \code{drop_zero} setting.}

\item{levels_brackets}{A list of \verb{<element_line>} objects to customise how
brackets appear at every level.}

\item{levels_text}{A list of \verb{<element_text>} objects to customise how
text appears at every level.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \verb{<PrimitiveBracket>} primitive guide that can be used inside other
guides.
}
\description{
This function constructs a brackets \link[=guide-primitives]{guide primitive}.
}
\section{Styling options}{
Below are the \link[ggplot2:theme]{theme} options that determine the styling of
this guide, which may differ depending on whether the guide is used in an
axis or a legend context.

Common to both types is the following:
\itemize{
\item \code{legendry.bracket} an \code{\link[ggplot2:element]{<element_line>}} for the
line used to draw the brackets.
\item \code{legendry.backet.size} a \code{\link[grid:unit]{<unit>}} setting the space afforded
to a bracket.
}
\subsection{As an axis guide}{
\itemize{
\item \verb{axis.text.\{x/y\}.\{position\}} an \code{\link[ggplot2:element]{<element_text>}}
for the text displayed over the brackets.
}
}

\subsection{As a legend guide}{
\itemize{
\item \code{legend.text} an \code{\link[ggplot2:element]{<element_text>}} for the text
displayed over the brackets.
}
}
}

\examples{
# A standard plot
p <- ggplot(mpg, aes(interaction(drv, year), displ)) +
 geom_point()

key <- key_range_manual(c(2, 4), c(5, 6), c("A", "B"))

# Adding as secondary guides
p + guides(
  x.sec = primitive_bracket(),
  y.sec = primitive_bracket(key = key)
)
}
\seealso{
Other primitives: 
\code{\link{primitive_box}()},
\code{\link{primitive_fence}()},
\code{\link{primitive_labels}()},
\code{\link{primitive_line}()},
\code{\link{primitive_segments}()},
\code{\link{primitive_spacer}()},
\code{\link{primitive_ticks}()},
\code{\link{primitive_title}()}
}
\concept{primitives}
