% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gps.R
\name{gpsOptions}
\alias{gpsOptions}
\alias{addControlGPS}
\alias{removeControlGPS}
\alias{activateGPS}
\alias{deactivateGPS}
\title{Options for the GPS Control}
\usage{
gpsOptions(
  position = "topleft",
  activate = FALSE,
  autoCenter = FALSE,
  maxZoom = NULL,
  setView = FALSE
)

addControlGPS(map, options = gpsOptions())

removeControlGPS(map)

activateGPS(map)

deactivateGPS(map)
}
\arguments{
\item{position}{Position of the Control}

\item{activate}{If TRUE activates the GPS on addition.}

\item{autoCenter}{If TRUE auto centers the map when GPS location changes}

\item{maxZoom}{If set zooms to this level when auto centering}

\item{setView}{If TRUE sets the view to the GPS location when found}

\item{map}{a map widget object}

\item{options}{Options for the GPS control.}
}
\description{
Options for the GPS Control

Add a gps to the Map.

Removes the GPS Control

Activate the GPS Control.
You should have already added the GPS control before calling this method.

Deactivate the GPS Control.
You should have already added the GPS control before calling this method.
}
\examples{
leaflet() \%>\%
  addTiles() \%>\%
  addControlGPS()
}
