% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville.R
\name{liouv.maxim}
\alias{liouv.maxim}
\alias{liouv.maxim.mm}
\title{Maximization of  Liouville copula likelihood function}
\usage{
liouv.maxim(
  data,
  family,
  interval,
  boundary = NULL,
  lattice.mat = NULL,
  return_all = FALSE,
  MC.approx = TRUE
)
}
\arguments{
\item{data}{sample matrix from a Liouville copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{interval}{interval over which to look for \code{theta} (bounds for Nelder-Mead)}

\item{boundary}{vector of endpoints for search of Dirichlet allocation parameters. Either \code{boundary} or \code{lattice.mat} can be supplied}

\item{lattice.mat}{matrix of tuples of Dirichlet allocation parameters at which to evaluate the likelihood}

\item{return_all}{should all results (as list) or only maximum value be returned. Defaults to \code{FALSE}}

\item{MC.approx}{whether to use Monte-Carlo approximation for the inverse survival function (default is \code{TRUE})}
}
\value{
a list with values of \code{theta} and Dirichlet parameter along with maximum found. Gives index of maximum amongst models fitted.
}
\description{
Two methods, either numerical optimization or method-of-moments
}
\details{
A wrapper to \code{optim} using the Nelder-Mead algorithm or using the methods of moments,
to maxime pointwise given every \code{alphavec} over a grid.
Returns the maximum for \code{alphavec} and \code{theta}.
}
\examples{
\dontrun{
 data <- rliouv(n=100, family="joe", alphavec=c(1,2), theta=2)
 liouv.maxim(data=data, family="j", interval=c(1.25,3), boundary=c(2,2),return_all=TRUE)
 lattice.mat <- t(combn(1:3,2))
 liouv.maxim(data=data, family="j", interval=c(1.25,3), lattice.mat=lattice.mat, return_all=FALSE)
 #data <- rliouv(n=1000, family="gumbel", alphavec=c(1,2), theta=2)
 liouv.maxim.mm(data=data, family="gumbel", boundary=c(3,3),return_all=TRUE)
 lattice.mat <- t(combn(1:3,2))
 liouv.maxim.mm(data=data, family="gumbel", lattice.mat=lattice.mat, return_all=FALSE)
}
}
