% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictL.lcmm.R
\name{predictL}
\alias{predictL}
\alias{predictL.lcmm}
\alias{predictL.multlcmm}
\alias{predictL.Jointlcmm}
\title{Class-specific marginal or subject-specific predictions in the latent process scale for
\code{lcmm}, \code{Jointlcmm} and \code{multlcmm} objects}
\usage{
predictL(
  x,
  newdata,
  var.time,
  na.action = 1,
  confint = FALSE,
  predRE = NULL,
  predCor = NULL,
  ...
)
}
\arguments{
\item{x}{an object inheriting from class \code{lcmm},\code{multlcmm} or
\code{Jointlcmm} representing a (joint) (latent class) mixed model involving
a latent process and estimated link function(s).}

\item{newdata}{data frame containing the data from which predictions are
computed. The data frame should include at least all the covariates listed
in x$Xnames2. Names in the data frame should be exactly x$Xnames2 that are
the names of covariates specified in \code{lcmm} or \code{multlcmm} calls.}

\item{var.time}{A character string containing the name of the variable that
corresponds to time in the data frame (x axis in the plot).}

\item{na.action}{Integer indicating how NAs are managed. The default is 1
for 'na.omit'. The alternative is 2 for 'na.fail'. Other options such as
'na.pass' or 'na.exclude' are not implemented in the current version.}

\item{confint}{logical indicating if confidence should be provided. Default
to FALSE.}

\item{predRE}{optional data frame containing the predicted random effects
in each latent class. If NULL (the default), marginal prediction are
computed.If predRE is specified, subject-specific predictions
are computed.}

\item{predCor}{optional matrix.
If \code{predCor} is specified, the returned predictions include the
correlation (BM or AR) part of the model. \code{predCor} should be a matrix
with as many columns as latent classes and as many rows as newdata.
In particular, predCor can be the result of a predictCor call.}

\item{\dots}{further arguments to be passed to or from other methods.  They
are ignored in this function.}
}
\value{
An object of class \code{predictL} with values :

- \code{pred} : a matrix containing the class-specific predicted values in
the latent process scale, the lower and the upper limits of the confidence
intervals (if calculated).

- \code{times} : the \code{var.time} variable from \code{newdata}
}
\description{
This function provides a matrix containing the class-specific predicted
trajectories computed in the latent process scale, that is the latent
process underlying the curvilinear outcome(s), for a profile of covariates
specified by the user. This function applies only to \code{lcmm}, \code{multlcmm} and
\code{Jointlcmm} objects.  The function
\code{predictY} provides the class-specific predicted trajectories computed
in the natural scale of the outcome(s).
}
\examples{

#### Prediction from a 2-class model with a Splines link function
\dontrun{
## fitted model
m<-lcmm(Ydep2~Time*X1,mixture=~Time,random=~Time,classmb=~X2+X3,
subject='ID',ng=2,data=data_lcmm,link="splines",B=c(
-0.175,      -0.191,       0.654,      -0.443, 
-0.345,      -1.780,       0.913,       0.016, 
 0.389,       0.028,       0.083,      -7.349, 
 0.722,       0.770,       1.376,       1.653, 
 1.640,       1.285))
summary(m)
## predictions for times from 0 to 5 for X1=0
newdata<-data.frame(Time=seq(0,5,length=100),
X1=rep(0,100),X2=rep(0,100),X3=rep(0,100))
predictL(m,newdata,var.time="Time")
## predictions for times from 0 to 5 for X1=1
newdata$X1 <- 1
predictY(m,newdata,var.time="Time")
}

}
\seealso{
\code{\link{predictY}},\code{\link{predictRE}},\code{\link{predictYcond}}
}
\author{
Cecile Proust-Lima, Viviane Philipps
}
