% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lancova.R
\name{lancova}
\alias{lancova}
\title{Logged ANCOVA}
\usage{
lancova(y, g, x, plot = F)
}
\arguments{
\item{y}{the raw posttest scores of a continuous outcome variable.}

\item{g}{the categorical variable that denotes the group membership}

\item{x}{the raw pretest scores of a continuous outcome variable.}

\item{plot}{a TRUE/FALSE variable that denotes if diagnostic plots are desired. (default=F)}
}
\value{
An summary object of the LANCOVA results.
In residuals, the summary statistics are of sample multiplicative errors.
In the coefficients table, the estimate of the intercept is the (control group) geometric mean estimate.
The estimate for the pretest scores is the power parameter beta's estimate.
Other coefficient estimates are effect size measure zeta's estimates. The standard error is on the logged scale.
The confidence intervals are of significance level = .05 for the control group geometric mean and for the zeta estimates,
respectively, of the intercept and other coefficients
The residual standard error is that of the logged scale residuals. Both R-squared and Adjusted R-squared are computed
on the logged model. If `plot=TRUE`, diagnostic plots are provided.
}
\description{
Mathematically, LANCOVA is the ANCOVA form of
a log-log model where both the dependent variable and the covariate
is log-transformed.
LANCOVA can test and estimate multiplicative effects.
}
\examples{
data("schoene")
attach(schoene)
lancova(post_HRT,group,pre_HRT)
}
