% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strand.R
\name{element.eval}
\alias{element.eval}
\title{Evaluating Element Fit}
\usage{
element.eval(obj)
}
\arguments{
\item{obj}{A seriated binary matrix.}
}
\value{
A \code{list} containing results in frames for row and column elements:
\itemize{
\item \code{RowFit} a data frame containing
\itemize{
\item \code{id} Row element
\item \code{p.val} \eqn{p} values of the row elements
}
\item \code{ColFit} a data frame containing
\itemize{
\item \code{id} Column element
\item \code{p.val} \eqn{p} values of the column elements
}
}
}
\description{
Performs a goodness-of-fit test on individual row and column elements using deviance, using a quadratic-logistic model to fit row and column occurrences. In the case of perfect separation of 0/1 values, an \code{NA} value is assigned. Results are reported as \eqn{p} values for each row and column.
}
\examples{
data("quattrofontanili")
element.eval(quattrofontanili)

}
