% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voxelize.R
\name{voxelize}
\alias{voxelize}
\title{Voxelize point cloud}
\usage{
voxelize(x, edge_length, threads = 1L)
}
\arguments{
\item{x}{A \code{\link[=data.frame]{data.frame}} or \code{\link[data.table:data.table]{data.table::data.table()}}
with columns containing the X, Y, and Z coordinates of every point. Any
additional columns are ignored.}

\item{edge_length}{A numeric \code{\link[=vector]{vector}} of length \code{3}, containing
values for the desired X, Y, and Z dimensions of each voxel.}

\item{threads}{The number of threads to use for computing the voxel data.
Default is 1.}
}
\value{
A data object of class '\code{lac_voxels}', which inherits from
\code{\link[data.table:data.table]{data.table::data.table()}}. The output contains 4 columns: X, Y, Z, and
N. The first three columns encode the spatial coordinates of each voxel
while the fourth denotes the total number of points they contain.
}
\description{
Bins point cloud data into 3D pixels, otherwise known as 'voxels'.
}
\examples{
# simulate a diagonal line of points with XYZ coordinates
pc <- data.frame(X = 0:99, Y = 0:99, Z = 0:99)
# convert point data to cubic voxels of length 5
voxelize(pc, edge_length = c(5,5,5))

}
