% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplexExport.R
\name{simplexExport}
\alias{simplexExport}
\title{Exports the information contained in an object of class \code{smplx}.}
\usage{
simplexExport(simplex, filename = NULL, direc = NULL)
}
\arguments{
\item{simplex}{object of class \code{smplx} containing the simplex to be
exported}

\item{filename}{string with the name (without extention) of the file that
will be created. If not provided, the name of the simplex
object is used.}

\item{direc}{directory in which the file will be saved. If not provided,
the current working directory is used.}
}
\value{
Generates a \code{.smplx} file containing all the information
        required to continue with the optimization process after the
        experiments have been carried.
}
\description{
Creates a text file with extension \code{.smplx} that contains the complete
information contained in a simplex (an object with class \code{smplx},
see \code{\link{labsimplex}}). This file allows the continuation of an
optimization proccess when the experiments take too long and multiple
\code{R} sessions are required. The file produced is also useful to share
the information of the optimization process. The exported simplex can be
later imported with \code{\link{simplexImport}}.
}
\examples{
  \donttest{
  simplex <- labsimplex(n = 5)
  simplexExport(simplex = simplex)
  }
}
\seealso{
\code{\link{simplexImport}}
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
