% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvk_search.R
\name{kvk_search}
\alias{kvk_search}
\title{Retrieve all results from the KvK Search API (up to 1,000 results)}
\usage{
kvk_search(..., test_environment = FALSE)
}
\arguments{
\item{...}{Named arguments passed to the API query (e.g., naam = "Koudum").
Available arguments can be found at
\url{https://developers.kvk.nl/documentation/zoeken-api#input}.}

\item{test_environment}{A logical value. If TRUE, uses the test environment
instead of the live API. Defaults to FALSE.}
}
\value{
A tibble containing the retrieved results. Possible parameters can be
found under the \code{Results} section of
\url{https://developers.kvk.nl/documentation/zoeken-api#output}.
}
\description{
This function automatically paginates through the KvK API to collect
available results. Due to API limitations, it retrieves a maximum of 1,000
records. When this happens, a warning will be displayed.
}
\details{
If \code{test_environment = TRUE}, it switches to the KvK's test environment,
using a mock API key for testing purposes.
}
\examples{
\dontshow{if (nzchar(Sys.getenv("KVK_API_KEY"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Examples using the production API (requires API key)
koudum <- kvk_search(plaats = "Koudum")
print(koudum)

rotterdam <- kvk_search(plaats = "Rotterdam")
print(rotterdam)

# Examples using test environment (no API key required)
test_data <- kvk_search(plaats = "Utrecht", test_environment = TRUE)
print(test_data)
\dontshow{\}) # examplesIf}
}
