% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvk_retrieve.R
\name{kvk_get_basisprofiel}
\alias{kvk_get_basisprofiel}
\title{Retrieve the Basisprofiel for a given KvK number}
\usage{
kvk_get_basisprofiel(
  kvkNummer,
  geoData = FALSE,
  include = NULL,
  test_environment = FALSE
)
}
\arguments{
\item{kvkNummer}{A string representing the KvK number for which the basis
profile is requested.}

\item{geoData}{A logical value indicating whether geo-data should be included
in the response. Defaults to \code{FALSE}. If \code{TRUE}, the response will include
geo-data.}

\item{include}{A character vector specifying additional data to include. Possible
values: \code{"eigenaar"} (owner), \code{"hoofdvestiging"} (main establishment),
\code{"vestigingen"} (locations). Defaults to \code{NULL} (basic profile only).}

\item{test_environment}{A logical value indicating whether to use the test
environment (\code{TRUE}) or the production environment (\code{FALSE}). Defaults to
\code{FALSE}.}
}
\value{
A tibble containing the retrieved basis profile. If \code{geoData = TRUE},
the returned tibble will also include geographical information.
}
\description{
This function retrieves the basis profile for a given KvK number
(\code{kvkNummer}) using the KvK Basisprofiel API. Users can also request
additional data, such as owner information, main establishment, and other
locations by specifying the \code{include} parameter.
}
\details{
The function also supports the \code{test_environment} argument. When set to
\code{TRUE}, the function will query the KvK test API environment, providing a
set of fictitious test data.

The function retrieves data from the KvK Basisprofiel API. If
\code{geoData = TRUE}, geo-data (e.g., location data) will be included in the
returned profile. The \code{include} parameter allows users to request
additional details, such as ownership information or business locations.

\strong{Important:} If \code{test_environment = TRUE}, no actual API key is required. You will be using
test data from the KvK test environment.
}
\examples{
\dontshow{if (nzchar(Sys.getenv("KVK_API_KEY"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Examples using the production API (requires API key)
# Retrieve basis profile for a given KvK number without geo-data
basis_profile <- kvk_get_basisprofiel(kvkNummer = "69599084")
print(basis_profile)

# Retrieve basis profile with geo-data
basis_profile_geo <- kvk_get_basisprofiel(kvkNummer = "69599084", geoData = TRUE)

# Retrieve basis profile including owner information
basis_profile_owner <- kvk_get_basisprofiel(kvkNummer = "69599084", include = "eigenaar")

# Examples using test environment (no API key required)
# These use the KvK test dataset with Donald Duck themed businesses
basis_profile_test <- kvk_get_basisprofiel(kvkNummer = "68727720", test_environment = TRUE)
print(basis_profile_test)
\dontshow{\}) # examplesIf}
}
