% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankkmed.R
\name{rankkmed}
\alias{rankkmed}
\title{Rank k-medoid algorithm}
\usage{
rankkmed(distdata, ncluster, m = 3, iterate = 10, init = NULL)
}
\arguments{
\item{distdata}{A distance matrix (n x n) or dist object.}

\item{ncluster}{A number of clusters.}

\item{m}{A number of objects to compute hostility (see
\strong{Details}).}

\item{iterate}{A number of iterations for the clustering algorithm.}

\item{init}{A vector of initial objects as the cluster medoids
(see \strong{Details}).}
}
\value{
Function returns a list of components:

\code{cluster} is the clustering memberships result.

\code{medoid} is the id medoids.

\code{minimum_distance} is the distance of all objects to their cluster
medoid.
}
\description{
This function runs the rank k-medoids algorithm proposed by
Zadegan et. al. (2013).
}
\details{
This algorithm is claimed to cope with the local optima problem
of the simple and fast-kmedoids algorithm (\code{\link{fastkmed}}). The
\code{m} argument is defined by the user and has to be \eqn{1 < m \leq n}.
The \code{m} is a hostility measure computed by
\deqn{m_i = \sum_{X_j \in Y} r_{ij}}
where \eqn{x_j} is the object j, Y is the set of objects
as many as m, and \eqn{r_{ij}} is the rank distance, i.e. sorted
distance, between object i and j.

\code{init} can be provided with a vector of id objects. The length of
the vector has to be equal to the number of clusters. However, assigning
a vector in the \code{init} argument, the algorithm is no longer the rank
k-medoids algorithm.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
result <- rankkmed(mrwdist, ncluster = 3, iterate = 50)
table(result$cluster, iris[,5])


}
\references{
Zadegan, S.M.R, Mirzaie M, and Sadoughi, F. 2013. Ranked k-medoids: A fast and
accurate rank-based partitioning algorithm for clustering large datasets. Knowledge-Based
Systems 39, 133-143.
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
