% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgeo_kriging_plot.R
\name{Rgeo_kriging_plot}
\alias{Rgeo_kriging_plot}
\title{Plotting Kriged Database}
\usage{
Rgeo_kriging_plot(krig_db, db, property)
}
\arguments{
\item{krig_db}{A kriged database object, resulting from the \code{Rgeo_kriging} function.}

\item{db}{The original database object that was used to generate the kriged database.}

\item{property}{A character string representing the property (or column name) from the database that you want to visualize e.g. "RC1" or "RC2".}
}
\value{
A plot comparing the specified \code{property} in the original and kriged databases.
}
\description{
This function creates a plot of the kriged database.
The function is designed specifically for visualizing geostatistical data.
}
\details{
The function takes a kriged database and the original database, then generates a comparative plot for a specific property.
This helps in understanding the effect of kriging on the selected property.
}
\examples{
if(requireNamespace("RGeostats", quietly = TRUE)){
    library(RGeostats)
    data("Klovan_Row80", package = "klovan")
    db <- Rgeo_database(Klovan_Row80, 3, "RC3")
    model <- Rgeo_vario_model(db, 3, "RC3", lag = 500, model = 13)
    krig_db <- Rgeo_kriging(db, model)
    Rgeo_kriging_plot(krig_db, db, "RC3")
}
}
