% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_kirby21_data.R
\name{delete_kirby21_data}
\alias{delete_kirby21_data}
\title{Delete Kirby21 Imaging Data}
\usage{
delete_kirby21_data(modality = kirby21.base::all_modalities(), outdir = NULL)
}
\arguments{
\item{modality}{modality of images that are to be downloaded.  You
must have the package downloaded for that modality.}

\item{outdir}{output directory for files to download.  It will
default to the directory of the corresponding package for the data.}
}
\value{
Nothing is returned
}
\description{
This function allows users to remove specific
modalities for Kirby21 data sets.  This allows this package to be 
on CRAN
}
\examples{
on_cran = !identical(Sys.getenv("NOT_CRAN"), "true")
on_ci <- nzchar(Sys.getenv("CI"))
local_run = grepl("musch", tolower(Sys.info()[["user"]]))
run_example = !on_cran || on_ci || local_run
if (run_example) {
outdir = tempdir()
res = download_kirby21_data("SURVEY", outdir = outdir, force = TRUE)
delete_kirby21_data("SURVEY", outdir = outdir)
}
}
