% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_functions.R
\name{utils_fit}
\alias{utils_fit}
\title{utils_fit a fonction running the kfino algorithm to filter data and 
  detect outliers under the knowledge of all parameters}
\usage{
utils_fit(param, threshold, kappa = 10, Y, Tps, N)
}
\arguments{
\item{param}{list, see initial parameter list in \code{kfino_fit}}

\item{threshold}{numeric, threshold for confidence interval, default 0.5}

\item{kappa}{numeric, truncation setting for likelihood optimization, 
default 10}

\item{Y}{character, name of the numeric variable to predict in the
data.frame datain}

\item{Tps}{character, time column name in the data.frame datain, a 
numeric vector.
Tvar can be expressed as a proportion of day in seconds}

\item{N}{numeric, length of the numeric vector of Y values}
}
\value{
a list
\describe{
 \item{prediction}{vector, the prediction of weights}
 \item{label}{vector, probability to be an outlier}
 \item{likelihood}{numeric, the calculated likelihood}
 \item{lwr}{vector of lower bound confidence interval of the prediction }
 \item{upr}{vector of upper bound confidence interval of the prediction }
 \item{flag}{char, is an outlier or not}
}
}
\description{
utils_fit a fonction running the kfino algorithm to filter data and 
  detect outliers under the knowledge of all parameters
}
\details{
utils_fit is a tool function used in the main \code{kfino_fit} 
function. It uses the same input parameter list than the main function.
}
\examples{
set.seed(1234)
Y<-rnorm(n=10,mean=50,4)
Tps<-seq(1,10)
N=10
param2<-list(m0=41,
             mm=45,
             pp=0.5,
             aa=0.001,
             expertMin=30,
             expertMax=75,
             sigma2_m0=1,
             sigma2_mm=0.05,
             sigma2_pp=5,
             K=2,
            seqp=seq(0.5,0.7,0.1))
print(Y)
utils_fit(param=param2,threshold=0.5,kappa=10,Y=Y,Tps=Tps,N=N)
}
