% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-id.R
\name{add_id}
\alias{add_id}
\title{Add identity column}
\usage{
add_id(.data, .id = ".id", .overwrite = FALSE)
}
\arguments{
\item{.data}{A data frame.}

\item{.id}{Column name for the ID (default: ".id").}

\item{.overwrite}{If TRUE, overwrite existing ID column. If FALSE (default),
error if column exists.}
}
\value{
Data frame with ID column added.
}
\description{
Adds a stable UUID column to each row. This is an opt-in feature for
tracking row lineage through transformations.
}
\details{
IDs are generated using a hash of row content plus a random salt,
making them stable for identical rows within a session but unique across
different data frames.

If the uuid package is available, it will be used for true UUIDs.
Otherwise, a hash-based ID is generated.
}
\examples{
df <- data.frame(x = 1:3, y = c("a", "b", "c"))
df <- add_id(df)
df

}
