% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossprod.r
\docType{methods}
\name{crossprod}
\alias{crossprod}
\alias{crossprod,shaq-method}
\title{Matrix Multiplication}
\usage{
\S4method{crossprod}{shaq}(x, y = NULL)
}
\arguments{
\item{x}{A shaq.}

\item{y}{Must be \code{NULL}.}
}
\value{
A regular matrix.
}
\description{
Conceptually, this computes \code{t(x) \%*\% x} for a shaq \code{x}.
}
\section{Communication}{

The operation consists of a local crossproduct, followed by an
\code{allreduce()} call, quadratic on the number of columns.
}

\examples{
\dontrun{
library(kazaam)
x = ranshaq(runif, 10, 3)

cp = crossprod(x)
comm.print(cp)

finalize()
}

}
