% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_adaptive.R
\name{fnhat_SS2011}
\alias{fnhat_SS2011}
\title{(Non-robust) Kernel Density Estimator of Srihera & Stute (2011)}
\usage{
fnhat_SS2011(x, data, K, h, theta, sigma)
}
\arguments{
\item{x}{Numeric vector with the location(s) at which the density estimate
is to be computed.}

\item{data}{Numeric vector \eqn{(X_1, \ldots, X_n)} of the data from which
the estimate is to be computed. Missing or infinite values are
not allowed and entail an error.}

\item{K}{A kernel function to be used for the estimator.}

\item{h}{Numeric scalar for bandwidth \eqn{h}.}

\item{theta}{Numeric scalar for value of location parameter \eqn{\theta}.}

\item{sigma}{Numeric scalar for value of scale parameter \eqn{\sigma}.}
}
\value{
An object with class "density" whose underlying structure is
        a list containing the following components (as described in
        \code{\link[stats]{density}}), so that the \code{print} and
        \code{plot} methods for \code{density}-objects are
        immediately available):
\tabular{ll}{
 \code{x}  \tab the n coordinates of the points where the density is
                estimated. \cr
 \code{y}  \tab the estimated density values from eq. (1.6) in Srihera &
                Stute (2011). \cr
 \code{bw} \tab the bandwidth used. \cr
 \code{n}  \tab the sample size. (Recall: missing or infinite values are
                not allowed here.) \cr
 \code{call}      \tab the call which produced the result. \cr
 \code{data.name} \tab the deparsed name of the x argument. \cr
 \code{has.na}    \tab logical, for compatibility (always FALSE). \cr\cr
 Additionally: \tab \cr
 \code{theta} \tab as in Arguments. \cr
 \code{sigma} \tab as in Arguments. \cr
 }
}
\description{
Implementation of eq. (1.6) in Srihera & Stute (2011) for given and fixed
scalars \eqn{\sigma} and \eqn{\theta} (and, of course, for fixed and given
location(s) in \eqn{x}, data \eqn{(X_1, \ldots, X_n)}, a kernel function
\eqn{K} and a bandwidth \eqn{h}).
}
\details{
The formula upon which the computational version implemented here is based
is given in eq. (15.3) of Eichner (2017). This function does mainly only a
simple preparatory computation and then calls \code{\link{compute_fnhat}}
which does the actual work.
}
\examples{
require(stats);   require(grDevices);    require(datasets)

 # Simulated N(0,1)-data and one sigma-value
set.seed(2017);     n <- 100;     d <- rnorm(n)
xgrid <- seq(-4, 4, by = 0.1)
(fit <- fnhat_SS2011(x = xgrid, data = d, K = dnorm, h = n^(-1/5),
  theta = mean(d), sigma = 1))
\donttest{
plot(fit, ylim = range(0, dnorm(0), fit$y), col = "blue")
curve(dnorm, add = TRUE);   rug(d, col = "red")
legend("topleft", lty = 1, col = c("blue", "black", "red"),
  legend = expression(tilde(f)[n], phi, "data")) }
\donttest{
 # The same data, but several sigma-values
sigmas <- seq(1, 4, length = 4)
(fit <- lapply(sigmas, function(sig)
  fnhat_SS2011(x = xgrid, data = d, K = dnorm, h = n^(-1/5),
    theta = mean(d), sigma = sig)))

ymat <- sapply(fit, "[[", "y")
matplot(x = xgrid, y = ymat, type = "l", lty = 1, col = 3:6,
  ylim = range(0, dnorm(0), ymat), main = "", xlab = "", ylab = "Density")
curve(dnorm, add = TRUE);   rug(d, col = "red")
legend("topleft", lty = 1, col = c("black", "red", NA), bty = "n",
  legend = expression(phi, "data", tilde(f)[n]~"in other colors")) }
\donttest{
 # Old-Faithful-eruptions-data and several sigma-values
d <- faithful$eruptions;     n <- length(d);     er <- extendrange(d)
xgrid <- seq(er[1], er[2], by = 0.1);    sigmas <- seq(1, 4, length = 4)
(fit <- lapply(sigmas, function(sig)
   fnhat_SS2011(x = xgrid, data = d, K = dnorm, h = n^(-1/5),
     theta = mean(d), sigma = sig)))

ymat <- sapply(fit, "[[", "y");     dfit <- density(d, bw = "sj")
plot(dfit, ylim = range(0, dfit$y, ymat), main = "", xlab = "")
rug(d, col = "red")
matlines(x = xgrid, y = ymat, lty = 1, col = 3:6)
legend("top", lty = 1, col = c("black", "red", NA), bty = "n",
  legend = expression("R's est.", "data", tilde(f)[n]~"in other colors")) }
}
\references{
Srihera & Stute (2011) and Eichner (2017): see \link{kader}.
}
\seealso{
\code{\link{fnhat_ES2013}}.
}
