% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spray1.R
\name{spray1}
\alias{spray1}
\title{spray1: Disaggregates population counts at high-resolution grid cells in the absence population and building counts - for one-level only}
\usage{
spray1(df, rdf, class, rclass, output_dir, verbose = TRUE)
}
\arguments{
\item{df}{A data frame object containing sample data (often partially observed) on different demographic groups population. It contains the admin's
total populatioin count to be disaggregated as well as other key variables as defined within the 'toydata'.}

\item{rdf}{A gridded data frame object containing key information on the grid cells. Variables include the admin_id which must be identical to the one
in the admin level data. It contains GPS coordinates. i.e, longitude (lon) and Latitude (lat) of the grid cell's centroids.}

\item{class}{These are the categories of the variables of interest. For example, for educational level, it could be 'no education', 'primary education', 'secondary education', 'tertiary education'.}

\item{rclass}{This is a user-defined names of the files to be saved in the output folder.}

\item{output_dir}{This is the directory with the name of the output folder where the
disaggregated population proportions and population totals are
automatically saved.}

\item{verbose}{Logical. If TRUE, prints progress messages. Default is TRUE.}
}
\value{
A list of data frame objects of the output files including the disaggregated population proportions and population totals
along with the corresponding measures of uncertainties (lower and upper bounds of 95-percent credible intervals) for each demographic characteristic.
In addition, a file containing the model performance/model fit evaluation metrics is also produced.
}
\description{
This function disaggregates population estimates at grid cell levels using the building counts of each grid cell to first disaggregate the admin unit's
total population across the grid cells. Then, each grid cell's total count is further disaggregated into groups of interest using the admin's proportions.
}
\examples{
\donttest{
if (requireNamespace("INLA", quietly = TRUE)) {
 library(raster) # load relevant libraries
 library(dplyr)
 library(terra)
 data(toydata) # load toy data

 # run 'cheesepop' admin unit disaggregation function
 result <- cheesepop(df = toydata$admin,output_dir = tempdir())
 class <- class <- names(toydata$admin \%>\% dplyr::select(starts_with("age_")))
 rclass <- paste0("TOY_population_v1_0_age",1:12)

 # run spray1 grid cell disaggregation function
 result2 <- spray1(df = result$full_data, rdf = toydata$grid, class, rclass, output_dir = tempdir())
 ras2<- rast(paste0(output_dir = tempdir(), "/pop_TOY_population_v1_0_age4.tif"))
 plot(ras2) # visulize of the raster files produced
}
}

}
