% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centerDataGLSModelSelection.R
\name{centerDataGLSModelSelection}
\alias{centerDataGLSModelSelection}
\title{Center Each Column By Subtracting Group or Global GLS Mean}
\usage{
centerDataGLSModelSelection(X, B.inv, group.one.indices, group.two.indices,
  group.cen.indices)
}
\arguments{
\item{X}{a data matrix.}

\item{B.inv}{an inverse row covariance matrix used in GLS}

\item{group.one.indices}{indices of observations in group one.}

\item{group.two.indices}{indices of observations in group two.}

\item{group.cen.indices}{indices of columns to be group centered}
}
\value{
Returns a centered data matrix of the same dimensions
as the original data matrix.
\item{X.cen}{Centered data matrix.}
\item{group.means.gls}{Group means estimated using GLS;
if all columns are globally centered, then \code{NULL}.}
\item{global.means.gls}{Global means estimated using GLS;
if all columns are group centered, then \code{NULL}.}
}
\description{
This function takes a data matrix, an inverse row covariance
matrix, group indices (i.e. row indices for membership in
groups one and two), and a subset of column indices indicating
which columns should be group centered.  It returns
a centered data matrix.  For each group centered column,
the two group means are estimated using GLS; then the group
one mean is subtracted from entries in group one, and the group
two mean is subtracted from entries in group two.  For each
globally centered column, a single global mean is estimated
using GLS and subtracted from each entry in the column.
In addition to returning the centered data matrix, this
function also returns the means estimated using GLS.
}
\details{
\bold{Example}
\preformatted{n <- 4
m <- 3
X <- matrix(1:12, nrow=n, ncol=m)
# Group center the first two columns, globally center
# the last column.
out <- centerDataGLSModelSelection(
  X, B.inv=diag(n), group.one.indices=1:2,
  group.two.indices=3:4,
  group.cen.indices=1:2)
# Display the centered data matrix
print(out$X.cen)
}
}
