% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{provigrep}
\alias{provigrep}
\alias{proigrep}
\title{provigrep: progressive case-insensitive value-grep}
\usage{
provigrep(
  patterns,
  x,
  maxValues = NULL,
  sortFunc = c,
  rev = FALSE,
  returnType = c("vector", "list"),
  ignore.case = TRUE,
  value = TRUE,
  ...
)

proigrep(..., value = FALSE)
}
\arguments{
\item{patterns}{\code{character} vector of regular expression patterns,
ultimately passed to \code{base::grep()}.}

\item{x}{\code{character} vector that is the subject of \code{base::grep()}.}

\item{maxValues}{\code{integer} or NULL, the maximum matching entries to
return per grep pattern. Note that each grep pattern may match multiple
values, and values are only returned at most once each, so restricting
items returned by one grep pattern may allow an item to be matched
by subsequent patterns, see examples. This argument is most commonly
used with \code{maxValues=1} which returns only the first matching entry
per pattern.}

\item{sortFunc}{\code{function} or NULL, used to sort entries within each set of
matching entries. Use NULL to avoid sorting entries.}

\item{rev}{\code{logical} whether to reverse the order of matching entries. Use
TRUE if you would like entries matching the patterns to be placed last,
and entries not matching the grep patterns to be placed first. This
technique is effective at placing "noise names" at the end of a long
vector, for example.}

\item{returnType}{\code{character} indicating whether to return a vector or list.
A list will be in order of the grep patterns, using empty elements to
indicate when no entries matched each pattern. This output is useful
when you would like to know which patterns matched specific entries.}

\item{ignore.case}{\code{logical} parameter sent to \code{base::grep()}, TRUE
runs in case-insensitive mode, as by default.}

\item{value}{\code{logical} indicating whether to return the matched value,
or when \code{value=FALSE} the index position is returned.}

\item{...}{additional arguments are passed to \code{vigrep()}.}
}
\value{
\code{character} vector with entries in \code{x} reordered to match
the order of \code{patterns} provided,  or \code{list} when \code{returnType="list"}
named by \code{patterns} in the order provided. When \code{value=FALSE} then
it returns \code{integer} index values of \code{x}.
}
\description{
case-insensitive value-grep for a vector of patterns

case-insensitive grep for a vector of patterns
}
\details{
Purpose is to provide "progressive vigrep()",which is value-returning,
case-insensitive grep, starting with an ordered vector of grep patterns.
For example, it returns entries in the order they are matched, by the
progressive use of grep patterns.

It is particularly good when using multiple grep patterns, since
\code{grep()} does not accept multiple patterns as input. This function
also only returns the unique matches in the order they were matched,
which alleviates the need to run a series of \code{grep()} functions
and collating their results.

It is mainly to allow for prioritized ordering of matching entries, where
one would like certain matching  entries first, followed by another
set of matching entries, without duplication. For example,
one might grep for a few patterns, but want certain pattern hits to be
listed first.
}
\examples{
# a rather comical example
# set up a test set with labels containing several substrings
set.seed(1);
testTerms <- c("robot","tree","dog","mailbox","pizza","noob");
testWords <- pasteByRow(t(combn(testTerms,3)));

# now pull out entries matching substrings in order
provigrep(c("pizza", "dog", "noob", "."), testWords);
# more detail about the sort order is shown with returnType="list"
provigrep(c("pizza", "dog", "noob", "."), testWords, returnType="list");
# rev=TRUE will reverse the order of the list
provigrep(c("pizza", "dog", "noob", "."), testWords, returnType="list", rev=TRUE);
provigrep(c("pizza", "dog", "noob", "."), testWords, rev=TRUE);

# another example showing ordering of duplicated entries
set.seed(1);
x <- paste0(
   sample(letters[c(1,2,2,3,3,3,4,4,4,4)]),
   sample(1:5));
x;
# sort by letter
provigrep(letters[1:4], x)

# show more detail about how the sort is performed
provigrep(letters[1:4], x, returnType="list")

# rev=TRUE will reverse the order of pattern matching
# which is most useful when "." is the last pattern:
provigrep(c(letters[1:3], "."), x, returnType="list")
provigrep(c(letters[1:3], "."), x, returnType="list", rev=TRUE)

# example demonstrating maxValues
# return in list format
provigrep(c("[ABCD]", "[CDEF]", "[FGHI]"), LETTERS, returnType="list")

# maxValues=1
provigrep(c("[ABCD]", "[CDEF]", "[FGHI]"), LETTERS, returnType="list", maxValues=1)
provigrep(c("[ABCD]", "[CDEF]", "[FGHI]"), LETTERS, returnType="list", maxValues=1, value=FALSE)
proigrep(c("[ABCD]", "[CDEF]", "[FGHI]"), LETTERS, maxValues=1)

}
\seealso{
Other jam grep functions: 
\code{\link{grepls}()},
\code{\link{igrep}()},
\code{\link{igrepHas}()},
\code{\link{igrepl}()},
\code{\link{unigrep}()},
\code{\link{unvigrep}()},
\code{\link{vgrep}()},
\code{\link{vigrep}()}
}
\concept{jam grep functions}
