% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{pasteByRow}
\alias{pasteByRow}
\title{Paste data.frame rows into character vector}
\usage{
pasteByRow(
  x,
  sep = "_",
  na.rm = TRUE,
  condenseBlanks = TRUE,
  includeNames = FALSE,
  sepName = ":",
  blankGrep = "^[ ]*$",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{data.frame} or comparable object such as \code{matrix} or \code{tibble}.}

\item{sep}{\code{character} string separator to use between columns.}

\item{na.rm}{\code{logical} whether to remove NA values, or include them
as \code{"NA"} strings.}

\item{condenseBlanks}{\code{logical} whether to condense blank or empty values
without including an extra delimiter between columns.}

\item{includeNames}{\code{logical} whether to include the colname delimited
prior to the value, using sepName as the delimiter.}

\item{sepName}{\code{character} string relevant when \code{includeNames=TRUE},
this value becomes the delimiter between name:value.}

\item{blankGrep}{\code{character} string used as regular expression pattern in
\code{grep()} to recognize blank entries;
by default any field containing no text, or only whitespace,
is considered a blank entry.}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{character} vector of length \code{nrow(x)}.
}
\description{
Paste data.frame rows into a character vector, optionally removing
empty fields in order to avoid delimiters being duplicated.
}
\details{
This function is intended to paste \code{data.frame} (or \code{matrix}, or \code{tibble})
values for each row of data.
It differs from using \code{apply(x, 2, paste)}:
\itemize{
\item it handles factors without converting to integer factor level numbers.
\item it also by default removes blank or empty fields, preventing the delimiter
from being included multiple times, per the \code{condenseBlanks} argument.
\item it is notably faster than apply, by means of running \code{paste()} on
each column of data, making the output vectorized, and scaling rather
well for large \code{data.frame} objects.
}

The output can also include name:value pairs, which can make the output
data more self-describing in some circumstances. That said, the most basic
usefulness of this function is to create row labels.
}
\examples{
# create an example data.frame
a1 <- c("red","blue")[c(1,1,2)];
b1 <- c("yellow","orange")[c(1,2,2)];
d1 <- c("purple","green")[c(1,2,2)];
df2 <- data.frame(a=a1, b=b1, d=d1);
df2;

# the basic output
pasteByRow(df2);

# Now remove an entry to show the empty field is skipped
df2[3,3] <- "";
pasteByRow(df2);

# the output tends to make good rownames
rownames(df2) <- pasteByRow(df2);

# since the data.frame contains colors, we display using
# imageByColors()
withr::with_par(list("mar"=c(5,10,4,2)), {
imageByColors(df2, cellnote=df2);
})

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
