% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{col2hsv}
\alias{col2hsv}
\title{Convert R color to HSV matrix}
\usage{
col2hsv(x, ...)
}
\arguments{
\item{x}{R color}

\item{...}{additional parameters are ignored}
}
\value{
matrix of HSV colors
}
\description{
Convert R color to HSV matrix
}
\details{
This function takes a valid R color and converts to a HSV matrix. The
output can be effectively returned to R color with
\code{\link{hsv2col}}, usually after manipulating the
HSV color matrix.
}
\examples{
# start with a color vector
# red and blue with partial transparency
colorV <- c("#FF000055", "#00339999");

# confirm the hsv matrix maintains transparency
col2hsv(colorV);

# convert back to the original color
hsv2col(col2hsv(colorV));

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
