% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isplit.R
\name{isplit}
\alias{isplit}
\title{Split Iterator}
\usage{
isplit(x, f, drop = FALSE, ...)
}
\arguments{
\item{x}{vector or data frame of values to be split into groups.}

\item{f}{a factor or list of factors used to categorize \code{x}.}

\item{drop}{logical indicating if levels that do not occur should be
dropped.}

\item{\dots}{current ignored.}
}
\value{
The split iterator.
}
\description{
Returns an iterator that divides the data in the vector \code{x} into the
groups defined by \code{f}.
}
\details{
Originally from the \code{iterators} package.
}
\examples{

x <- rnorm(200)
f <- factor(sample(1:10, length(x), replace = TRUE))

it <- isplit(x, f)
expected <- split(x, f)

for (i in expected) {
    actual <- nextOr(it, break)
    stopifnot(actual$value == i)
}

}
\seealso{
\code{\link{split}}
}
