% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itempool-class.R
\docType{class}
\name{Testlet-class}
\alias{Testlet-class}
\title{An S4 class to represent a Testlet}
\description{
\code{Testlet} is a class to represent an a collection of items. Items that
are connected by a common stimulus (for example a reading passage, a graph,
etc.) can form a testlet. An object in \code{Testlet} class should
have a \code{model} name and \code{item_list} which is an \code{Itempool}.
object. In fact, a \code{Testlet} object is very similar to an
\code{\link{Itempool-class}} object, except, it has a designated model and
optional parameters.
}
\section{Slots}{

\describe{
\item{\code{testlet_id}}{Testlet ID. Default value is \code{NULL}.}

\item{\code{item_list}}{A list of \code{Item} objects.}

\item{\code{model}}{The model that testlet \code{parameters} represents. Currently
model can be:
BTM (Basic Testlet Model, this is default testlet model where no
     parameters necessary and testlet simply connects items),
RTM (Rasch Testlet Model),
BF (Bifactor Model) (Not implemented yet),
2PTM (Two-parameter testlet model),
3PTM (three-parameter testlet model).
A model must be specified for the construction of an \code{tetlet} object.}

\item{\code{parameters}}{A list containing numeric vectors that represent testlet
parameters. Depending on the model these parameters can change.}

\item{\code{se_parameters}}{Standard error of testlet parameters.}

\item{\code{content}}{Content information for testlet.}

\item{\code{misc}}{A list of additional parameters for the testlet.}
}}

\author{
Emre Gonulates
}
