% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_restriction.R
\name{lMvrrc}
\alias{lMvrrc}
\title{Lawley multivariate range restriction correction.}
\usage{
lMvrrc(rcov, vnp, as_cor = TRUE)
}
\arguments{
\item{rcov}{The covariance matrix of the restricted sample.}

\item{vnp}{The covariance matrix of predictors explicitly used for selection. 
This matrix should be based on the the unrestricted population.}

\item{as_cor}{This argument can be set to FALSE to return a covariance matrix.}
}
\value{
The the correlation matrix or variance covariance in the unrestricted population.
}
\description{
Lawley multivariate range restriction correction.
}
\examples{
data(rcea1994)
vstar <- rcea1994$vstar
vpp   <- rcea1994$vpp

lMvrrc(rcov=vstar, vnp=vpp)
}
\author{
The original function was written by Adam Beatty and adapted by Allen Goebl.
}
\references{
Lawley D. N (1943). A note on Karl Pearson's selection formulae. 
            \emph{Proceedings of the Royal Society of Edinburgh.},
            62(Section A, Pt. 1), 28-30.
}

