% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai.R
\name{aiPux}
\alias{aiPux}
\title{Estimate ai and average criterion scores for majority and minority groups.}
\usage{
aiPux(mr, dx, dy = 1, sr, pct_minority)
}
\arguments{
\item{mr}{The correlation between the predictor and criterion composites.}

\item{dx}{A vector of d values for the predictors. These d values are expected
to have been computed in the direction of Majority - Minority.}

\item{dy}{A vector of d values for the criteria These d values are expected
to have been computed in the direction of Majority - Minority.}

\item{sr}{The percentage of the applicant population who are selected.}

\item{pct_minority}{The percentage of the applicant population who are part of
a given minority group.}
}
\value{
\itemize{
            \item{AI}{Adverse Impact}
            \item{Overeall_sr}{The overall selection ratio set by the user}
            \item{Majority_sr}{Majority Selection Rate}
            \item{Minority_sr}{Minority Selection Rate}
            \item{Majority_Standardized}{Predicted composite criterion score relative to the majority population}
            \item{Global_Standardized}{Predicted composite criterion score relative to the overall population} 
         }
}
\description{
Estimate ai and average criterion scores for majority and minority groups.
}
\examples{
aiPux(.6, dx=.8, sr=.3, pct_minority=.25)
aiPux(.6, dx=.8, dy=.2, sr=.3, pct_minority=.25)
}
\author{
Jeff Jones and Allen Goebl
}
\references{
De Corte, W., Lievens, F.(2003). A Practical procedure to estimate
the quality and the adverse impact of single-stage selection decisions.
\emph{International Journal of Selection and Assessment.}, 11(1), 87-95.
}

