% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkr_factor_screening.R
\name{GKRFactorScreening}
\alias{GKRFactorScreening}
\title{Factor screening procedure of Gospodinov-Kan-Robotti (2014)}
\usage{
GKRFactorScreening(
  returns,
  factors,
  target_level = 0.05,
  hac_prewhite = FALSE,
  check_arguments = TRUE
)
}
\arguments{
\item{returns}{\verb{n_observations x n_returns}-dimensional matrix of test asset
excess returns.}

\item{factors}{\verb{n_observations x n_factors}-dimensional matrix of risk
factors.}

\item{target_level}{Number specifying the target significance threshold for the
tests underlying the GKR factor screening procedure.
To account for the multiple testing problem, the significance threshold for the
absolute t-test is given by \code{target_level_gkr2014_screening / n_factors},
where n_factors indicate the number of factors in the model at the current iteration.
Default is \code{0.05}.}

\item{hac_prewhite}{A boolean indicating if the series needs prewhitening by
fitting an AR(1) in the internal heteroskedasticity and autocorrelation
robust covariance (HAC) estimation. Default is \code{false}.}

\item{check_arguments}{boolean \code{TRUE} for internal check of all function
arguments; \code{FALSE} otherwise. Default is \code{TRUE}.}
}
\value{
A list contaning the selected GKR SDF coefficients in \code{SDF_coefficients},
their standard errors in \code{standard_errors},
t-statistics in \code{t_statistics} and indices in the columns of the factor matrix \code{factors}
supplied by the user in \code{selected_factor_indices}.
}
\description{
Performs the factor screening procedure of
Gospodinov-Kan-Robotti (2014) \url{doi:10.2139/ssrn.2579821}, which is
an iterative model screening procedure
based on the sequential removal of factors associated with the smallest insignificant
t-test of a nonzero misspecification-robust SDF coefficient. The significance threshold for the
absolute t-test is set to \code{target_level / n_factors},
where n_factors indicates the number of factors in the model at the current iteration;
that is, it takes care of the multiple testing problem via a conservative
Bonferroni correction. Standard errors are computed with the
heteroskedasticity and autocorrelation using the Newey-West (1994)
\url{doi:10.2307/2297912} estimator, where the number of lags
is selected using the Newey-West plug-in procedure:
\code{n_lags = 4 * (n_observations/100)^(2/9)}.
For the standard error computations, the function allows to internally
pre-whiten the series by fitting a VAR(1),
i.e., a vector autoregressive model of order 1.
All the details can be found in Gospodinov-Kan-Robotti (2014) \url{doi:10.2139/ssrn.2579821}.
}
\examples{
# import package data on 6 risk factors and 42 test asset excess returns
factors = intrinsicFRP::factors[,-1]
returns = intrinsicFRP::returns[,-1]

# Perform the GKR factor screening procedure
screen = GKRFactorScreening(returns, factors)

}
