% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_model.R
\name{forecast_volume}
\alias{forecast_volume}
\title{Forecast One-bin-ahead Intraday Volume}
\usage{
forecast_volume(model, data, burn_in_days = 0)
}
\arguments{
\item{model}{A model object of class "\code{volume_model}" from \code{fit_volume()}.}

\item{data}{An n_bin * n_day matrix or an \code{xts} object storing intraday volume.}

\item{burn_in_days}{Number of initial days in the burn-in period. Samples from the first \code{burn_in_days} are used to warm up the model and then are discarded.}
}
\value{
A list containing the following elements:
       \itemize{
        \item{\code{original_signal}: }{A vector of original intraday volume;}
        \item{\code{forecast_signal}: }{A vector of forecast intraday volume;}
        \item{\code{forecast_components}: }{A list of the three forecast components: daily, seasonal, intraday dynamic, and residual components.}
        \item{\code{error}: }{A list of three error measures: mae, mape, and rmse.}
        }
}
\description{
This function forecasts one-bin-ahead intraday volume.
Its mathematical expression is \eqn{\hat{y}_{\tau+1} = E[y_{\tau+1}|\{y_{j}\}_{j=1}^{\tau}]}{y*(\tau+1) = E[y(\tau + 1) | y(j), j = 1, ... , \tau]}.
It is a wrapper of \code{decompose_volume()} with \code{purpose = "forecast"}.
}
\examples{
library(intradayModel)
data(volume_aapl)
volume_aapl_training <- volume_aapl[, 1:20]
volume_aapl_testing <- volume_aapl[, 21:50]
model_fit <- fit_volume(volume_aapl_training, fixed_pars = list(a_mu = 0.5, var_mu = 0.05),
                        init_pars = list(a_eta = 0.5))
                        
# forecast testing volume
forecast_result <- forecast_volume(model_fit, volume_aapl_testing)

# forecast testing volume with burn-in
forecast_result <- forecast_volume(model_fit, volume_aapl[, 1:50], burn_in_days = 20)

}
\references{
Chen, R., Feng, Y., and Palomar, D. (2016). Forecasting intraday trading volume: A Kalman filter approach. Available at SSRN 3101695.
}
\author{
Shengjie Xiu, Yifan Yu and Daniel P. Palomar
}
