% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper}
\alias{bru_mapper}
\alias{bru_mapper_define}
\title{Constructors for \code{bru_mapper} objects}
\usage{
bru_mapper(...)

bru_mapper_define(mapper, new_class = NULL, remove_class = "list", ...)
}
\arguments{
\item{\dots}{Arguments passed on to sub-methods, or used for special
purposes, see details for each function below.}

\item{mapper}{For \code{bru_mapper_define}, a prototype mapper object, see
Details.}

\item{new_class}{If non-\code{NULL}, this is added at the front of the class
definition}

\item{remove_class}{If non-\code{NULL}, this class or classes is removed from the
class definition before adding the \code{new_class} names. Default is \code{"list"}.}
}
\value{
\itemize{
\item \code{bru_mapper()} returns a \code{bru_mapper} object
}
}
\description{
Constructors for \code{bru_mapper} objects
}
\section{Functions}{
\itemize{
\item \code{bru_mapper()}: Generic mapper S3 constructor, used for constructing
mappers for special objects. See below for details of the
default constructor \code{\link[=bru_mapper_define]{bru_mapper_define()}} that can be used to define
new mappers in user code.

\item \code{bru_mapper_define()}: Adds the \code{new_class} and \code{"bru_mapper"} class names to
the inheritance list for the input \code{mapper} object, unless the object
already inherits from these.

To register mapper classes and methods in scripts, use \code{.S3method()}
to register the methods, e.g.
\code{.S3method("ibm_jacobian", "my_mapper_class", ibm_jacobian.my_mapper_class)}.

In packages with \code{Suggests: inlabru}, add method information for delayed
registration, e.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @rawNamespace S3method(inlabru::bru_get_mapper, inla_rspde)
#' @rawNamespace S3method(inlabru::ibm_n, bru_mapper_inla_rspde)
#' @rawNamespace S3method(inlabru::ibm_values, bru_mapper_inla_rspde)
#' @rawNamespace S3method(inlabru::ibm_jacobian, bru_mapper_inla_rspde)
}\if{html}{\out{</div>}}

or before each method, use \verb{@exportS3Method}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @exportS3Method inlabru::bru_get_mapper
}\if{html}{\out{</div>}}

etc., which semi-automates it.

}}
\examples{
mapper <- bm_index(5)
ibm_jacobian(mapper, input = c(1, 3, 4, 5, 2))
}
\seealso{
\link{bru_mapper_generics} for generic methods,
the individual mapper pages for special method implementations, and
\link{bru_get_mapper} for hooks to extract mappers from latent model object
class objects.

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
