% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_tablet_weight.R
\docType{data}
\name{tablet_weight}
\alias{tablet_weight}
\title{Weight measurements of pharmaceutical tablets}
\format{
An object of class tibble with 137 observations on 3 variables
}
\source{
Anonymized data based on statistical process control data obtained in a high
volume production setup.
}
\usage{
tablet_weight
}
\description{
This data set contains weight measurements of pharmaceutical 
tablets (pills). The data and the #' insights it provides are typical of an
industrial context with high production throughput and stringent dimensional 
requirements.
}
\details{
The data set contains other variables not used in the text book related with 
to the measurement room conditions (not listed).

\describe{
  \item{part_id}{Unique sequencial identifier given during production (numeric)}
  \item{Weight Target Value}{Tablet weight target specification value in [mg] (numeric}
  \item{Weight Value}{Tablet weight measured value [m] (numeric)}
}
}
\examples{
hist(tablet_weight$`Weight value`)
}
\references{
For a complete case study application refer to \url{https://j-ramalho.github.io/industRial/}
}
\keyword{datasets}
