% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{dLogitNorm}
\alias{dLogitNorm}
\title{density for logit transformed univariate Gaussian}
\usage{
dLogitNorm(x, mu, sigma)
}
\arguments{
\item{x, }{numeric real}

\item{mu, }{numeric real}

\item{sigma, }{numeric real positive}
}
\value{
tranformed density on support (0, 1)
}
\description{
density for logit transformed univariate Gaussian
}
\examples{
mu <- -1
sigma <- 1
z <- rnorm(10000, mu, sigma)
hist(exp(z)/(1 + exp(z)), freq = FALSE)
curve(dLogitNorm(x, mu = mu, sigma = sigma), col = 'red', add = TRUE, from = 0.01, to = 0.99)
integrate(function(x) dLogitNorm(x, mu = mu, sigma = sigma), lower = 0, upper = 1) # equals 1
}
