% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbmle.r
\name{lbmle}
\alias{lbmle}
\title{Maximum Likelihood Estimation of Intrinsic Dimension.}
\usage{
lbmle(x = NULL, k1 = NULL, k2 = NULL, BC = TRUE, DM = FALSE, p = NULL)
}
\arguments{
\item{x}{data matrix or distance matrix given by as.matrix(dist(x)).}

\item{k1}{first k-NN parameter.}

\item{k2}{second k-NN parameter.}

\item{BC}{whether bias is corrected or not. logical.}

\item{DM}{whether \code{'x'} is distance matrix or not. logical.}

\item{p}{ambient dimension used for automatically define \code{'k1'} and \code{'k2'}.}
}
\value{
Estimated global intrinsic dimension.
}
\description{
\code{lbmle} estimate the intrinsic dimension of a given dataset.
}
\details{
The likelihood of the rate parameter of the Poisson process, which characterize the behaviour of  
the distance from a point to another point in the given dataset, is considered, and the maximum likelihood estimator (MLE) for the intrinsic dimension is derived.
The original method proposed by Levina and Bickel contains a known bias, and it is corrected by Mackay and Ghahramani. This function implements both, with the default the bias corrected estimate.
}
\examples{
x <- gendata(DataName='SwissRoll',n=300)
estmle <- lbmle(x=x,k1=3,k2=5)
print(estmle)
}
\references{
E. Levina and P. J. Bickel. Maximum likelihood estimation of 
intrinsic dimension. Advances in Neural Information Processing Systems 17, 2005.

D. MacKay and Z. Ghahramani. \url{http://www.inference.org.uk/mackay/dimension/}
}
\author{
Hideitsu Hino \email{hideitsu.hino@gmail.com}
}
