% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulationFunctions.R
\name{simDC_weib}
\alias{simDC_weib}
\title{Simulate Doubly Censored Data}
\usage{
simDC_weib(
  n = 100,
  b1 = 0.5,
  b2 = -0.5,
  model = "ph",
  shape = 2,
  scale = 2,
  lowerLimit = 0.75,
  upperLimit = 2
)
}
\arguments{
\item{n}{Number of observations}

\item{b1}{Regression coefficient 1}

\item{b2}{Regression coefficient 2}

\item{model}{Regression model to use. Choices are \code{"ph"}, \code{"po"} or \code{"aft"}}

\item{shape}{Baseline shape parameter}

\item{scale}{Baseline scale parameter}

\item{lowerLimit}{Lower censoring threshold}

\item{upperLimit}{Upper censoring threshold}
}
\description{
Simulates doubly censored data from a survival regression model 
with a Weibull baseline distribution.
}
\details{
Exact event times are simulated according to the given survival regression model.
Two covariates are used; \code{x1 = rnorm(n), x2 = 1 - 2 * rbinom(n, 1, .5)}. After
event times are simulated, all values less than \code{lowerLimit} are left censored
and all values less than \code{upperLimit} are right censored.
}
\examples{
simData <- simDC_weib()
fit <- ic_par(cbind(l, u) ~ x1 + x2, data = simData)
}
