% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ispls.cv.R
\name{ispls.cv}
\alias{ispls.cv}
\title{Cross-validation for ispls}
\usage{
ispls.cv(x, y, L, K, mu1, mu2, eps = 1e-04, kappa = 0.05,
  pen1 = "homogeneity", pen2 = "magnitude", scale.x = TRUE,
  scale.y = TRUE, maxstep = 50, submaxstep = 10)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{y}{list of data matrices, L datasets of dependent variables.}

\item{L}{numeric, number of datasets.}

\item{K}{numeric, number of cross-validation folds. Default is 5.}

\item{mu1}{numeric, the feasible set of sparsity penalty parameter.}

\item{mu2}{numeric, the feasible set of contrasted penalty parameter.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{kappa}{numeric, 0 < kappa < 0.5 and the parameter reduces the effect of the concave part of objective function.}

\item{pen1}{character, "homogeneity" or "heterogeneity" type of the sparsity structure. If not specified, the default is homogeneity.}

\item{pen2}{character, "magnitude" or "sign" based contrasted penalty. If not specified, the default is magnitude.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{scale.y}{character, "TRUE" or "FALSE", whether or not to scale the variables y. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}

\item{submaxstep}{numeric, maximum iteration steps in the sub-iterations. The default value is 10.}
}
\value{
An 'ispls.cv' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{y:}{ list of data matrices, L datasets of dependent variables with centered columns. If scale.y is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{mu1:}{ the sparsity penalty parameter selected from the feasible set of parameter mu1 provided by users.}
\item{mu2:}{ the contrasted penalty parameter selected from the feasible set of parameter mu2 provided by users.}
\item{fold:}{ The fold assignments for cross-validation for each observation.}
\item{betahat:}{ the estimated regression coefficients with selected tuning parameters mu1 and mu2.}
\item{loading:}{ the estimated first direction vector with selected tuning parameters mu1 and mu2.}
\item{variable:}{ the screening results of variables x.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
\item{meany:}{ list of numeric vectors, column mean of the original datasets y.}
\item{normy:}{ list of numeric vectors, column standard deviation of the original datasets y.}
}
}
\description{
Performs K-fold cross validation for the integrative sparse partial least squares over a grid of values for the regularization parameter mu1 and mu2.
}
\examples{
\donttest{
# Load a list with 3 data sets
library(iSFun)
data("simData.pls")
x <- simData.pls$x
y <- simData.pls$y
L <- length(x)
mu1 <- c(0.04, 0.05)
mu2 <- 0.25

res_homo_m <- ispls.cv(x = x, y = y, L = L, K = 5, mu1 = mu1, mu2 = mu2, eps = 1e-2,
                       kappa = 0.05, pen1 = "homogeneity", pen2 = "magnitude",
                       scale.x = TRUE, scale.y = TRUE, maxstep = 50, submaxstep = 10)

res_homo_s <- ispls.cv(x = x, y = y, L = L, K = 5, mu1 = mu1, mu2 = mu2, eps = 1e-2,
                       kappa = 0.05, pen1 = "homogeneity", pen2 = "sign",
                       scale.x = TRUE, scale.y = TRUE, maxstep = 50, submaxstep = 10)

res_hete_m <- ispls.cv(x = x, y = y, L = L, K = 5, mu1 = mu1, mu2 = mu2, eps = 1e-2,
                       kappa = 0.05, pen1 = "heterogeneity", pen2 = "magnitude",
                       scale.x = TRUE, scale.y = TRUE, maxstep = 50, submaxstep = 10)

res_hete_s <- ispls.cv(x = x, y = y, L = L, K = 5, mu1 = mu1, mu2 = mu2, eps = 1e-2,
                       kappa = 0.05, pen1 = "heterogeneity", pen2 = "sign",
                       scale.x = TRUE, scale.y = TRUE, maxstep = 50, submaxstep = 10)
}
}
\references{
\itemize{
\item{Liang W, Ma S, Zhang Q, et al. Integrative sparse partial least squares[J]. Statistics in Medicine, 2021, 40(9): 2239-2256.}
}
}
\seealso{
See Also as \code{\link{ispls}}.
}
