% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_hm_agg.R
\name{hm_agg}
\alias{hm_agg}
\alias{hm_agg,hydromet_station-method}
\alias{hm_agg,hydromet_compact-method}
\title{Aggregates the table inside a slot to a larger time period}
\usage{
hm_agg(
  obj,
  slot_name,
  col_name,
  fun,
  period,
  out_name = NULL,
  allow_na = 0,
  start_month = 1,
  end_month = 12,
  relocate = NULL
)

\S4method{hm_agg}{hydromet_station}(
  obj,
  slot_name,
  col_name,
  fun,
  period,
  out_name = NULL,
  allow_na = 0,
  start_month = 1,
  end_month = 12,
  relocate = NULL
)

\S4method{hm_agg}{hydromet_compact}(
  obj,
  slot_name,
  col_name,
  fun,
  period,
  out_name = NULL,
  allow_na = 0,
  start_month = 1,
  end_month = 12
)
}
\arguments{
\item{obj}{a valid \code{hydromet_XXX} class object.}

\item{slot_name}{string with the name of the slot to aggregate.}

\item{col_name}{string with column(s) name(s) to aggregate.}

\item{fun}{string with supported aggregation function name (one per \option{col_name}):
\option{mean}, \option{min}, \option{max}, \option{sum}, \option{last} or \option{first}.}

\item{period}{string with the aggregation time-step: \option{hourly}, \option{daily},
\option{monthly}, \option{annually} or \option{climatic}. \bold{NOTE 1}: the
\option{climatic} option returns the all series annual statistics (\option{fun}).
\bold{NOTE 2}: when using \option{annually} as \bold{period}, the method will return
the starting dates in the first slot column.}

\item{out_name}{string with the output column(s) name(s). Default values coerce the
original name plus the \option{fun} argument (e.g.: \code{tair_max}).}

\item{allow_na}{optional. Numeric value with the maximum allowed number of \code{NA_real_}
values. By default the function will not tolerate any \code{NA_real_} (and will
return \code{NA_real_} instead).}

\item{start_month}{optional. Numeric value defining the first month of the annual
period (it just make sense if \option{period} is either \option{annually} or
\option{climatic}). Default sets to 1 (January). \bold{NOTE}: keep in mind that if
you choose \option{climatic} as period you have to round off a complete year (e.g.:
\code{..., start_month = 6, end_month = 5, ...})}

\item{end_month}{optional. Numeric value defining the last month of the annual period
(it just make sense if \option{period} is either \option{annually} or \option{climatic}).
Default sets to 12 (December). \bold{NOTE}: keep in mind that if you choose
\option{climatic} as period you have to round off a complete year (e.g.:
\code{..., start_month = 6, end_month = 5, ...})}

\item{relocate}{optional. String with the name of the slot where to allocate the
aggregated table. It only make sense for \code{hydromet_station} class. When using
it you must keep in mind that all aggregated series are allocated in a single slot.}
}
\value{
A data frame with the Date and the aggregated variable(s) inside the
specified slot.
}
\description{
This method allows you to get your data temporally aggregated.
}
\section{Functions}{
\itemize{
\item \code{hm_agg(hydromet_station)}: temporal aggregation method for station class

\item \code{hm_agg(hydromet_compact)}: temporal aggregation method for compact class

}}
\examples{
\dontrun{
# cuevas station
path <- system.file('extdata', package = 'hydrotoolbox')

# use the build method
hm_cuevas <-
  hm_create() \%>\%
  hm_build(bureau = 'ianigla', path = path,
           file_name = 'ianigla_cuevas.csv',
           slot_name = c('tair', 'rh', 'patm',
                         'precip', 'wspd', 'wdir',
                         'kin', 'hsnow', 'tsoil'),
           by = 'hour',
           out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                        'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                        'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)' )
          )

# aggregate air temperature data to mean value
hm_agg(obj = hm_cuevas, slot_name = 'tair', col_name = 'tair(°C)',
      fun = 'mean', period = 'daily', out_name = 't_mean') \%>\%
 hm_show(slot_name = 'tair')

# the previous command overwrites the original slot, so now we are going
# to relocate the agg values
hm_agg(obj = hm_cuevas, slot_name = 'tair',
      col_name = 'tair(°C)',
      fun = 'mean',
      period = 'daily',
      relocate = 'tmean',
      out_name = 'tmean(°C)',
      ) \%>\%
 hm_show(slot_name = 'tmean')
}


}
