% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AE.R
\name{peaktrace}
\alias{peaktrace}
\title{Trace Longitudinal Hydropeaking Waves Along a River Section}
\usage{
peaktrace(
  relation_path,
  events_path,
  initial_values_path,
  settings_path,
  unique = c("time", "metric"),
  inputdec = ".",
  inputsep = ",",
  event_type = c(2, 4),
  saveResults = FALSE,
  outdir = tempdir(),
  TimeFormat = "\%Y-\%m-\%d \%H:\%M",
  tz = "Etc/GMT-1",
  formula = y ~ x,
  model = stats::lm,
  FKM_MAX = 65,
  impute_method = base::max,
  ...
)
}
\arguments{
\item{relation_path}{Character string containing the path of the file where
the relation file is to be read from with
\code{\link[utils:read.csv]{utils::read.csv()}}. The file must contain a
column \code{ID} that contains the gauging station ID. ID's in the file have to be
in order of their location in downstream direction.}

\item{events_path}{Character string containing the path of the directory
where the event files corresponding to the `relation' file are located. Only
relevant files in this directory will be used, i.e., files that are related to
the `relation' file.}

\item{initial_values_path}{Character string containing the path of the file
which contains initial values for predictions (see vignette).}

\item{settings_path}{Character string containing the path where the
settings files are to be read from with
\code{\link[utils:read.csv]{utils::read.csv()}} if
available. The settings files must be in the format of the
output of \code{\link[=peaktrace]{peaktrace()}}. If missing or
incomplete, the settings are determined automatically.}

\item{unique}{Character string specifying if the potential AEs which
meet the \code{timeLag} and \code{metricLag} condition should
be filtered to contain only unique events using \code{"time"},
i.e., by selecting those where the time difference is smallest
compared to the specified factor of the mean translation time, or using
\code{"metric"}, i.e., by selecting those where the relative
difference in amplitude is smallest (default: \code{"time"}).}

\item{inputdec}{Character string for decimal points in input data.}

\item{inputsep}{Field separator character string for input data.}

\item{event_type}{Vector specifying the event type that is used to identify
event files by their file names
(see \code{\link[hydropeak:get_events]{hydropeak::get_events()}}).
Default: \code{c(2, 4)}, i.e., increasing and decreasing events.}

\item{saveResults}{A logical. If \code{FALSE} (default), the generated plots
and the estimated settings are not saved. Otherwise the settings are written
to a csv file and the plots are saved as png and pdf files.}

\item{outdir}{Character string naming a directory where the estimated
settings should be saved to.}

\item{TimeFormat}{Character string giving the date-time format of the
date-time column in the input data frame (default: "\%Y-\%m-\%d \%H:\%M").}

\item{tz}{Character string specifying the time zone to be used for the
conversion (default: "Etc/GMT-1").}

\item{formula}{An object of class \code{\link[stats:formula]{stats::formula()}}
to fit models.}

\item{model}{Function which specifies the method used for fitting models
(default: \code{\link[stats:lm]{stats::lm()}}). The model class must have a
\code{\link[stats:predict]{stats::predict()}} function.}

\item{FKM_MAX}{Numeric value that specifies the maximum fkm (see `relation'
file) for which predictions seem valid.}

\item{impute_method}{Function which specifies the method used for imputing
missing values in initial values based on potential AEs
(default: \code{\link[base:max]{base::max()}}).'}

\item{...}{Additional arguments to be passed to the function specified in
argument \code{model}.}
}
\value{
A nested list containing an element for each event type in order as
    defined in \code{event_type}. Each element contains again six elements,
    namely a data frame of estimated settings, a `\code{gtable}' object that specifies
    the combined plot of all stations (plot it with
    \code{\link[grid:grid.draw]{grid::grid.draw()}}), a data frame containing
    \dQuote{real} AEs (i.e., events where the relative difference in amplitude is within
    the estimated cut points), a grid of scatterplots (`gtable` object) for
    neighboring hydrographs with a regression line for each metric, a data
    frame of results of the model fitting where each row contains the
    corresponding stations and metric, the model type (default: "lm"), formula,
    coefficients, number of observations and \eqn{R^2}, and a plot of predicted
    values based on the \dQuote{initial values}.
}
\description{
Estimates all settings based on the `relation' file of a river
    section. The function uses a single `relation' file and determines the
    settings for all neighboring stations with
    \code{\link[=estimate_AE]{estimate_AE()}} for all event types specified in
    \code{event_type}. It fits models to describe translation and retention
    processes between neighboring hydrographs, and generates plots
    (see vignette for details). Given a file with initial values (see vignette),
    predictions are made and visualized in a plot.
    Optionally, the results can be written to a directory.
    All files need to have the same separator (\code{inputsep}) and
    character for decimal points (\code{inputdec}).
}
