% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scour.R
\name{scour_groyne}
\alias{scour_groyne}
\title{Scour depth formed by a groyne}
\usage{
scour_groyne(v,Fr,B,h,J,L,d16,dm,d84,Ks,delta,Kb=NULL,l=NULL, fs=0,
method="Froehlich",bedload=FALSE)
}
\arguments{
\item{v}{flow velocity upstream the groyne [m/s]}

\item{Fr}{Froude number upstream the groyne [-]}

\item{B}{sole width [m]}

\item{h}{flow depth upstream the groyne [m]}

\item{J}{bottom slope [-]}

\item{L}{length of the groyne (perpendicular to the river) [m]}

\item{d16}{d16 of grain size distribution [mm]}

\item{dm}{d50 of grain size distribution [mm]}

\item{d84}{d84 of grain size distribution [mm]}

\item{Ks}{shape value according to "Froehlich". values between 0.55 and 1
are recomended.[-]}

\item{delta}{horizontal angle of the groyne in respect to the river [°]}

\item{Kb}{shape value according to "Hoffmanns" [-]}

\item{l}{length of the groyne (parallel to the river)[m]}

\item{fs}{safety factor [-]}

\item{method}{method to calculate scour depth. valid values are "Froehlich"}

\item{bedload}{Consider bedload transportation if bedload =TRUE}
}
\value{
\item{T0}{water table at maximal scour depth [m]}
\item{S}{difference between bed elevation at the middle of the river and
  the maximal scour depth  [m]}
}
\description{
Calculate scour depth formed by a groyne
}
\examples{
## calculate scour depth accordint to Froehlich without bedload

v <- 2.7
Fr <- 0.52
h <- 3.31
J <- 0.0022
L <- 5
d16 <- 50
dm <- 80
d84 <- 200
Ks <- 0.82
delta <- 60

scour_groyne(
  v = v, Fr = Fr, h = h, J = J, L = L,
  d16 = d16, dm = dm, d84 = d84,
  Ks = Ks, delta = delta
)

## calculate scour depth accordint to Froehlich with bedload

v <- 2.7
Fr <- 0.52
h <- 3.31
J <- 0.0022
L <- 5
Ks <- 0.82
delta <- 60

scour_groyne(
  v = v, Fr = Fr, h = h, J = J, L = L,
  d16 = d16, dm = dm, d84 = d84,
  Ks = Ks, delta = delta, bedload = TRUE
)

}
\references{
Bezzola (2012). Vorlesungsmanuskript Flussbau. ETH Zürich.
}
