% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hwig.R
\name{calc_hwi}
\alias{calc_hwi}
\title{Calculate HWI}
\usage{
calc_hwi(DT, id, group, by = NULL)
}
\arguments{
\item{DT}{input group membership data, in individual/group format}

\item{id}{column indicating id in DT}

\item{group}{column indicating group in DT}

\item{by}{column(s) to split calculation by. e.g.: year}
}
\value{
HWI data.table or list of data.tables.
}
\description{
Calculates the Half-Weight Association Index
}
\details{
Expects an input `DT` with id and group column, e.g. as returned by \link[spatsoc]{group_pts}.
}
\examples{
# Load data.table
library(data.table)

# Load example data
DT <- fread(system.file("extdata", "DT.csv", package = "hwig"))

# Calculate HWI
hwi <- calc_hwi(DT, 'id', 'group', 'yr')
}
\seealso{
\link[hwig]{calc_hwig}
}
