% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_model_out_tbl.R
\name{as_model_out_tbl}
\alias{as_model_out_tbl}
\title{Convert model output to a \code{model_out_tbl} class object.}
\usage{
as_model_out_tbl(
  tbl,
  model_id_col = NULL,
  output_type_col = NULL,
  output_type_id_col = NULL,
  value_col = NULL,
  sep = "-",
  trim_to_task_ids = FALSE,
  hub_con = NULL,
  task_id_cols = NULL,
  remove_empty = FALSE
)
}
\arguments{
\item{tbl}{a \code{data.frame} or \code{tibble} of model output data returned from a query
to a \verb{<hub_connection>} object.}

\item{model_id_col}{character string. If a \code{model_id} column does not
already exist in \code{tbl}, the \code{tbl} column name containing \code{model_id} data.
Alternatively, if both a \code{team_abbr} and a \code{model_abbr} column exist, these will
be merged automatically to create a single \code{model_id} column.}

\item{output_type_col}{character string. If an \code{output_type} column does not
already exist in \code{tbl}, the \code{tbl} column name containing \code{output_type} data.}

\item{output_type_id_col}{character string. If an \code{output_type_id} column does not
already exist in \code{tbl}, the \code{tbl} column name containing \code{output_type_id} data.}

\item{value_col}{character string. If a \code{value} column does not
already exist in \code{tbl}, the \code{tbl} column name containing \code{value} data.}

\item{sep}{character string. Character used as separator when concatenating
\code{team_abbr} and \code{model_abbr} column values into a single \code{model_id} string. Only
applicable if \code{model_id} column not present and \code{team_abbr} and \code{model_abbr} columns are.}

\item{trim_to_task_ids}{logical. Whether to trim \code{tbl} to task ID columns only. Task ID
columns can be specified by providing a \verb{<hub_connection>} class object to \code{hub_con} or
manually through \code{task_id_cols}.}

\item{hub_con}{a \verb{<hub_connection>} class object. Only used if
\code{trim_to_task_ids = TRUE} and tasks IDs should be determined from the hub config.}

\item{task_id_cols}{a character vector of column names. Only used if
\code{trim_to_task_ids = TRUE} to manually specify task ID columns to retain.
Overrides \code{hub_con} argument if provided.}

\item{remove_empty}{Logical. Whether to remove columns containing only \code{NA}.}
}
\value{
A \code{model_out_tbl} class object.
}
\description{
Convert model output to a \code{model_out_tbl} class object.
}
\examples{
as_model_out_tbl(hub_con_output)
}
