% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiwaveplot.R
\name{simulator_plot}
\alias{simulator_plot}
\title{Plot simulator outputs for multiple waves}
\usage{
simulator_plot(
  wave_points,
  z,
  zero_in = TRUE,
  palette = NULL,
  wave_numbers = seq(ifelse(zero_in, 0, 1), length(wave_points) - ifelse(zero_in, 1, 0)),
  normalize = FALSE,
  logscale = FALSE,
  byhit = FALSE,
  barcol = "#444444",
  ...
)
}
\arguments{
\item{wave_points}{The set of wave points, as a list of data.frames}

\item{z}{The set of target values for each output}

\item{zero_in}{Is wave zero included? Default: TRUE}

\item{palette}{If a larger palette is required, it should be supplied here.}

\item{wave_numbers}{Which waves to plot. If not supplied, all waves are plotted.}

\item{normalize}{If true, plotting is done with rescaled target bounds.}

\item{logscale}{If true, targets are log-scaled before plotting.}

\item{byhit}{Should runs be grouped by number of targets hit, rather than wave?}

\item{barcol}{The colour of the target error bars/bounds}

\item{...}{Optional parameters (not to be used directly)}
}
\value{
A ggplot object.
}
\description{
Plots the simulator results for points at successive waves.
}
\details{
The values plotted are the outputs from the simulator; the points passed to it are the
points suggested by that wave of emulators. By default, wave 0 is included. A colour
scheme is chosen outright for all invocations of this function: it is a 10-colour
palette. If more waves are required, then an alternative palette should be selected.

The output can be plotted in a number of ways: raw; with outputs transformed to log scale;
or with targets normalised so that target bounds are all [-1, 1]. These two options may
be helpful in visualising behaviour when outputs have vastly different scales, but one
still wishes to see them all in the same plot: these options can be toggled by setting
\code{logscale = TRUE} or \code{normalize = TRUE} respectively. The data can be grouped in
two ways, either colouring by wave of emulation (default) or by the number of targets hit;
the latter option is enabled by setting \code{byhit = TRUE}.
}
\examples{
 simulator_plot(SIRMultiWaveData, SIREmulators$targets)
 simulator_plot(SIRMultiWaveData[2:4], SIREmulators$targets,
  zero_in = FALSE, wave_numbers = c(1,3))
 simulator_plot(SIRMultiWaveData, SIREmulators$targets, byhit = TRUE)

}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{hit_by_wave}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{space_removed}()},
\code{\link{validation_pairs}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
