% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlighter.R
\name{highlighterOutput}
\alias{highlighterOutput}
\alias{renderHighlighter}
\title{Shiny bindings for highlighter}
\usage{
highlighterOutput(outputId, width = "100\%", height = "auto")

renderHighlighter(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a highlighter}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An object of class \code{shiny.tag.list}

An object of class \code{shiny.render.function}
}
\description{
Output and render functions for using highlighter within Shiny
applications and interactive Rmd documents.
}
