% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.mixturecure}
\alias{print.mixturecure}
\title{Print the contents of a mixture cure fitted object}
\usage{
\method{print}{mixturecure}(x, max = 6, ...)
}
\arguments{
\item{x}{a \code{mixturecure} object resulting from \code{curegmifs},
\code{cureem}, \code{cv_cureem}, or \code{cv_curegmifs}.}

\item{max}{maximum number of rows in a matrix or elements in a vector to
display}

\item{...}{other arguments.}
}
\value{
prints coefficient estimates for the incidence portion of the model
and if included, prints the coefficient estimates for the latency portion of
the model. Also prints rate for exponential and Weibull models and scale
(alpha) for the Weibull mixture cure model. Returns all objects fit using
\code{cureem}, \code{curegmifs}, \code{cv_cureem}, or \code{cv_curegmifs}.
}
\description{
This function prints the first several incidence and latency coefficients,
the rate (when fitting an exponential or Weibull mixture cure model), and
alpha (when fitting a Weibull mixture cure model). This function returns
the fitted object invisible to the user.
}
\note{
The contents of a \code{mixturecure} fitted object differ depending
upon whether the EM (\code{cureem}) or GMIFS (\code{curegmifs}) algorithm is
used for model fitting or if cross-validation is used. Also, the output
differs depending upon whether \code{x_latency} is specified in the model
(i.e., variables are included in the latency portion of the model fit) or
only \code{terms} on the right hand side of the equation are included (i.e.,
variables are included in the incidence portion of the model).
}
\examples{
library(survival)
withr::local_seed(1234)
temp <- generate_cure_data(n = 100, j = 10, n_true = 10, a = 1.8)
training <- temp$training
fit <- curegmifs(Surv(Time, Censor) ~ .,
  data = training, x_latency = training,
  model = "weibull", thresh = 1e-4, maxit = 2000,
  epsilon = 0.01, verbose = FALSE
)
print(fit)
}
\seealso{
\code{\link{curegmifs}}, \code{\link{cureem}},
\code{\link{coef.mixturecure}}, \code{\link{summary.mixturecure}},
\code{\link{plot.mixturecure}}, \code{\link{predict.mixturecure}}
}
\keyword{methods}
